%define git %nil
%def_enable tests
%def_enable systemd

Name: libratbag
Version: 0.18
Release: alt1
Summary: Programmable input device library
Group: System/Libraries
License: MIT
Url: https://github.com/libratbag/libratbag
Source0: https://github.com/libratbag/%name/archive/v%version/%name-%version.tar.gz
Patch: %name-%version-%release.patch

BuildRequires(pre): meson
BuildRequires: pkgconfig gcc-c++ libevdev-devel libudev-devel libunistring-devel
BuildRequires: glib2-devel python3-dev swig libjson-glib-devel
%if_enabled systemd
BuildRequires: libsystemd-devel
%else
BuildRequires: libelogind-devel
%endif
%{?_enable_tests:BuildRequires: check python3-module-pygobject3 python3-module-lxml python3-module-evdev}

%description
libratbag is a library that allows to configure programmable
mice.

%package -n liblur
Summary: Logitech Unifying Receiver library
Group: System/Libraries

%description -n liblur
The liblur package contains libraries and tools to access and
configure the Logitech Unifying Receivers. The functionality
are mainly listing, pairing and un-pairing Logitech devices
attached to a receiver.

%package -n liblur-devel
Summary: Development files for liblur
Group: Development/C
Requires: liblur = %EVR

%description -n liblur-devel
The liblur-devel package contains libraries and header files for
developing applications that use liblur.

%package -n ratbagd
Summary: System daemon to introspect and modify configurable mice
Group: System/Configuration/Hardware
Requires: %name-data = %EVR

%description -n ratbagd
System daemon to introspect and modify configurable mice using libratbag.

%package tools
Summary: Mice configuration tools using libratbag
Group: System/Configuration/Hardware
Requires: ratbagd = %EVR

%description tools
Mice configuration tools using libratbag.

%package data
Summary: Libratbag mice configuration data
Group: System/Configuration/Hardware
BuildArch: noarch
Requires: ratbagd = %EVR

%description data
Libratbag mice configuration data.

%prep
%setup
%patch -p1

%build
%meson \
    -Ddocumentation=false \
%if_enabled tests
    -Dtests=false \
%endif
%if_enabled systemd
    -Dsystemd-unit-dir=%_unitdir
%else
    -Dlogind-provider=elogind \
    -Dsystemd=false
%endif
%meson_build

%if_enabled tests
%check
%meson_test
%endif

%install
%meson_install

%files -n liblur
%_libdir/liblur.so.*

%files -n liblur-devel
%_includedir/liblur.h
%_libdir/liblur.so
%_pkgconfigdir/liblur.pc

%files -n ratbagd
%doc COPYING README* TODO
%_sbindir/ratbagd
%_datadir/dbus-1/system.d/*.conf
%_datadir/dbus-1/system-services/*.service
%if_enabled systemd
%_unitdir/*.service
%endif
%_man8dir/*.8*

%files tools
%_bindir/ratbagctl
%_bindir/lur-command
%_man1dir/ratbagctl.1*
%_man1dir/lur-command.1*

%files data
%dir %_datadir/libratbag
%_datadir/libratbag

%changelog
