Name: libpjsip
Version: 2.14.1
Release: alt1

Summary: Libraries for building embedded/non-embedded VoIP applications

License: GPLv2+
Group: System/Libraries
Url: http://www.pjsip.org

# Source-url: https://github.com/pjsip/pjproject/archive/refs/tags/%version.tar.gz
Source: %name-%version.tar

BuildRequires: gcc-c++
BuildRequires: libalsa-devel libgsm-devel libsrtp2-devel libuuid-devel
BuildRequires: libssl-devel libspeex-devel libspeexdsp-devel libwebrtc-devel

%description
This package provides the Open Source, comprehensive, high performance,
small footprint multimedia communication libraries written in C
language for building embedded/non-embedded VoIP applications.
It contains:
- PJSIP - Open Source SIP Stack
- PJMEDIA - Open Source Media Stack
- PJNATH - Open Source NAT Traversal Helper Library
- PJLIB-UTIL - Auxiliary Library
- PJLIB - Ultra Portable Base Framework Library
- PJSUA2 - Object Oriented abstractions layer for PJSUA

%package devel
Summary: Development files to use pjproject
Group: Development/Other
Requires: %name = %version-%release

%description devel
Header information for:
- PJSIP - Open Source SIP Stack
- PJMEDIA - Open Source Media Stack
- PJNATH - Open Source NAT Traversal Helper Library
- PJLIB-UTIL - Auxiliary Library
- PJLIB - Ultra Portable Base Framework Library

%prep
%setup

%build
%add_optflags -DPJ_HAS_IPV6=1
%configure --enable-shared        \
           --with-external-gsm    \
           --with-external-speex  \
           --with-external-srtp   \
           --enable-sound         \
           --enable-resample      \
           --disable-video        \
           --disable-v4l2         \
           --disable-libyuv       \
           --disable-ilbc-codec   \
           --disable-g7221-codec  \
           --disable-opencore-amr \
           --disable-libwebrtc    \
           --enable-epoll

%make_build

%install
%makeinstall_std
# Remove the static libraries, as they aren't wanted
find %buildroot%_libdir -type f -name '*.a' -delete

%files
%_libdir/libpj.so.2
%_libdir/libpjlib-util.so.2
%_libdir/libpjmedia-audiodev.so.2
%_libdir/libpjmedia-codec.so.2
%_libdir/libpjmedia-videodev.so.2
%_libdir/libpjmedia.so.2
%_libdir/libpjnath.so.2
%_libdir/libpjsip-simple.so.2
%_libdir/libpjsip-ua.so.2
%_libdir/libpjsip.so.2
%_libdir/libpjsua.so.2
%_libdir/libpjsua2.so.2
%_libdir/libresample.so.2

%files devel
%_libdir/lib*.so
%_includedir/pj++/
%_includedir/pj/
%_includedir/pjlib-util/
%_includedir/pjmedia-audiodev/
%_includedir/pjmedia-codec/
%_includedir/pjmedia-videodev/
%_includedir/pjmedia/
%_includedir/pjnath/
%_includedir/pjsip-simple/
%_includedir/pjsip-ua/
%_includedir/pjsip/
%_includedir/pjsua-lib/
%_includedir/pjsua2/
%_includedir/*.h
%_includedir/*.hpp
%_pkgconfigdir/libpjproject.pc

%changelog
