%define sover 9
%def_enable check

%define stdxx 17

Name: libphonenumber
Version: 9.0.19
Release: alt1

Summary: Library to handle international phone numbers
License: Apache-2.0 and BSD-3-Clause and MIT
Group: System/Libraries
Url: https://github.com/google/libphonenumber

Vcs: https://github.com/google/libphonenumber.git

Source: %url/archive/v%version/%name-%version.tar.gz
# link libgeocoding against libphonenumber
Patch1: %name-8.13.4-alt-link.patch
Patch2: %name-9.0.16-alt-fix-nostatic-build.patch

BuildRequires(pre): rpm-macros-cmake
BuildRequires: cmake gcc-c++
BuildRequires: boost-devel
BuildRequires: libicu-devel
BuildRequires: protobuf-compiler
BuildRequires: libprotobuf-devel
# required libabseil-cpp built with -DCMAKE_POSITION_INDEPENDENT_CODE=ON
BuildRequires: libabseil-cpp-devel >= 20211102.0-alt3
BuildRequires: /proc /usr/bin/java
#BuildRequires: /usr/bin/mvn junit mockito
%{?_enable_check:BuildRequires: ctest libgtest-devel}

%description
Google's common C++ library for parsing, formatting, storing and validating
international phone numbers.

%package devel
Summary: Development files for %name
Group: Development/C++
Requires: %name = %EVR

%description devel
The %name-devel package contains libraries and header files for
developing applications that use %name.

%prep
%setup -n %name-%version/cpp
%patch1 -b .link
%patch2 -b .static

%ifarch %e2k
# the problematic warning actually sits in protobuf (-Winvalid-offsetof)
sed -i 's/-Werror/-Wno-error/g' {,../tools/cpp/}CMakeLists.txt
%endif

# gtest > 1.13 requires >= C++14
# libabseil compiled with -std=gnu++17
sed -i '/cmake_minimum_required/a set(CMAKE_CXX_STANDARD %stdxx)' CMakeLists.txt

%build
%cmake \
    %{?_disable_check:-DBUILD_TESTING=OFF} \
    -DBUILD_SHARED_LIBS=ON \
    -DBUILD_STATIC_LIB=OFF
%nil
%cmake_build

%install
%cmake_install

%check
%cmake_build -t tests

%files
%_libdir/%name.so.%{sover}*
%_libdir/libgeocoding.so.%{sover}*
%doc README

%files devel
%_includedir/phonenumbers/
%_libdir/libgeocoding.so
%_libdir/%name.so
%_libdir/cmake/%name/

%changelog
