%def_enable snapshot

%define ver_major 1.38
%define beta .alpha
%define api_ver 1.0
%define gtk_api_ver 3.0

%def_disable js
# removed since 1.10.0
%def_disable gjs
# not ready for lua-5.3
%def_disable lua
%def_disable python2
%def_enable introspection
%def_disable vala
%def_enable gtk_doc
%def_disable glade_catalog
%def_disable check

Name: libpeas
Version: %ver_major.0
Release: alt0.5%beta

Summary: A gobject-based plugins engine
Group: System/Libraries
License: LGPL-2.1-or-later
Url: https://wiki.gnome.org/Projects/Libpeas

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
%else
Source: %name-%version%beta.tar
%endif

%define glib_ver 2.85.0

BuildRequires(pre): rpm-macros-meson rpm-build-gir
BuildRequires: meson
BuildRequires: libgio-devel >= %glib_ver libgtk+3-devel >= 3.0.0
# for python3 support
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python3-module-pygobject3-devel >= 3.1.1
%{?_enable_introspection:BuildRequires: gobject-introspection-devel >= 1.31.10 libgtk+3-gir-devel}
%{?_enable_python2:
BuildRequires(pre): rpm-build-python
BuildRequires: python-devel python-module-pygobject3-devel >= 3.1.1}
%{?_enable_js:BuildRequires: libseed-devel >= 3.2.0}
%{?_enable_gjs:BuildRequires: libgjs-devel >= 1.37.1}
%{?_enable_lua:BuildRequires: liblua5-devel luajit libluajit-devel lgi >= 0.9.0}
%{?_enable_vala:BuildRequires: vala-tools >= 0.14}
%{?_enable_gtk_doc:BuildRequires: gi-docgen}
%{?_enable_glade_catalog:BuildRequires: libgladeui2.0-devel xmllint}
%{?_enable_check:BuildRequires: xvfb-run}

%description
%name is a convenience library making adding plug-ins support
to GTK+ and glib-based applications.

%package python-loader
Summary: Python loader for %name
Group: System/Libraries
Requires: %name = %version-%release

%description python-loader
This package provides Python loader for %name

%package python3-loader
Summary: Python3 loader for %name
Group: System/Libraries
Requires: %name = %version-%release

%description python3-loader
This package provides Python3 loader for %name

%package js-loader
Summary: Javascript loader for %name
Group: System/Libraries
Requires: %name = %version-%release

%description js-loader
This package provides WebKit Javascript loader for %name

%package gjs-loader
Summary: Javascript loader for %name
Group: System/Libraries
Requires: %name = %version-%release

%description gjs-loader
This package provides MozJS Javascript loader for %name

%package lua-loader
Summary: LUA loader for %name
Group: System/Libraries
Requires: %name = %version-%release

%description lua-loader
This package provides LUA-5.1 loader for %name

%package devel
Summary: Development files for %name
Group: Development/C
Requires: %name = %version-%release

%description devel
This package contains development libraries and header files
that are needed to write applications that use %name.

%package devel-doc
Summary: Development documentation for the %name
Group: Development/Documentation
Conflicts: %name < %version-%release
BuildArch: noarch

%description devel-doc
%name is a convenience library making adding plug-ins support
to GTK+ and glib-based applications.

This package contains development documentation for the %name.

%package gir
Summary: GObject introspection data for the %name
Group: System/Libraries
Requires: %name = %version-%release

%description gir
GObject introspection data for the %name

%package gir-devel
Summary: GObject introspection devel data for the %name
Group: Development/C
BuildArch: noarch
Requires: %name-gir = %version-%release

%description gir-devel
GObject introspection devel data for the %name

%package demo
Summary: %name demonstration program
Group: Development/C
Requires: %name = %version-%release
Requires: %name-gir = %version-%release

%description demo
%name is a convenience library making adding plug-ins support
to GTK+ and glib-based applications.

This package contains %name demonstration programs

%prep
%setup -n %name-%version%beta

%build
%meson \
    %{?_enable_gtk_doc:-Dgtk_doc=true} \
    %{?_enable_python2:-Dpython2=true} \
    %{?_enable_vala:-Dvapi=true} \
    %{?_disable_introspection:-Dintrospection=false} \
    %{?_disable_glade_catalog:-Dglade_catalog=false}
%nil
%meson_build

%install
%meson_install
%find_lang --output=%name.lang %name-%api_ver

%check
xvfb-run %__meson_test


%files -f %name.lang
%_libdir/%{name}*-%api_ver.so.*
%dir %_libdir/%name-%api_ver/loaders
#%_libdir/%name-%api_ver/loaders/libcloader.so
%_datadir/icons/hicolor/*/*/*
%doc AUTHORS README

%if_enabled python2
%files python-loader
%_libdir/%name-%api_ver/loaders/libpythonloader.so
%endif

%files python3-loader
%_libdir/%name-%api_ver/loaders/libpython3loader.so

%if_enabled js
%files js-loader
%_libdir/%name-%api_ver/loaders/libseedloader.so
%endif

%if_enabled gjs
%files gjs-loader
%_libdir/%name-%api_ver/loaders/libgjsloader.so
%endif

%if_enabled lua
%files lua-loader
%_libdir/%name-%api_ver/loaders/liblua*loader.so
%endif

%files devel
%_libdir/%{name}*-%api_ver.so
%_includedir/%name-%api_ver/
%_pkgconfigdir/*.pc
%{?_enable_glade_catalog:%_datadir/glade/catalogs/%name-gtk.xml}

%if_enabled gtk_doc
%files devel-doc
%_datadir/doc/%name-%api_ver
%_datadir/doc/%name-gtk-%api_ver
%endif

%files demo
%_bindir/peas-demo
%add_python3_path %_libdir/peas-demo
%_libdir/peas-demo/

%if_enabled introspection
%files gir
%_typelibdir/*

%files gir-devel
%_girdir/*
%endif


%changelog
