%define soname 1
%def_disable devel

Name: libpaper%soname
Version: 1.1.28
Release: alt4

Summary: Library and tools for handling papersize

License: GPL-2.0-only
Group: System/Legacy libraries
Url: http://packages.qa.debian.org/libp/libpaper.html

# Source-url: http://deb.debian.org/debian/pool/main/libp/libpaper/libpaper_%version.tar.gz
Source: %name-%version.tar

# Fedora's patches:
Patch1: libpaper-covscan.patch
Patch2: libpaper-file-leak.patch
Patch3: libpaper-useglibcfallback.patch

# Automatically added by buildreq on Sun Jan 08 2006
BuildRequires: gcc-c++ libstdc++-devel

%description
The paper library and accompanying files are intended to provide a simple
way for applications to take actions based on a system- or user-specified
paper size.  This release is quite minimal, its purpose being to provide
really basic functions (obtaining the system paper name and getting
the height and width of a given kond of paper) that applications can
immediately integrate.

%package -n libpaper
Summary: Library for handling papersize
Group: System/Legacy libraries
Provides: libpaper1 = %EVR
Obsoletes: libpaper1 < %EVR

%description -n libpaper
The paper library and accompanying files are intended to provide a simple
way for applications to take actions based on a system- or user-specified
paper size.  This release is quite minimal, its purpose being to provide
really basic functions (obtaining the system paper name and getting
the height and width of a given kond of paper) that applications can
immediately integrate.

This package contains the libpaper.so.1 library.

%if_enabled devel
%package devel
Summary: Header files for %name
Group: Development/Other
Requires: libpaper = %EVR

%description devel
Header files for %name library.
%endif

%prep
%setup
#patch1 -p1
%patch2 -p1
%patch3 -p1

%build
%autoreconf
%configure --disable-static
# Disable rpath
#sed -i 's|^hardcode_libdir_flag_spec=.*|hardcode_libdir_flag_spec=""|g' libtool
#sed -i 's|^runpath_var=LD_RUN_PATH|runpath_var=DIE_RPATH_DIE|g' libtool
%make_build

%install
%makeinstall_std
rm %buildroot%_libdir/*.la
mkdir -p %buildroot%_sysconfdir
echo '# Simply write the paper name. See papersize(5) for possible values' > %buildroot%_sysconfdir/papersize
mkdir -p %buildroot%_sysconfdir/libpaper.d
for i in cs da de es fr gl hu it ja nl pt_BR sv tr uk vi; do
    mkdir -p %buildroot%_datadir/locale/$i/LC_MESSAGES/;
    msgfmt debian/po/$i.po -o %buildroot%_datadir/locale/$i/LC_MESSAGES/%name.mo;
done
%find_lang %name

%if_disabled devel
rm -rv %buildroot%_libdir/libpaper.so
rm -rv %buildroot%_includedir/paper.h
rm -rv %buildroot%_man3dir/
%endif

# drop files (conflict with libpaper2)
rm -v %buildroot%_bindir/paperconf
rm -v %buildroot%_sbindir/paperconfig

%files -n libpaper -f %name.lang
%doc README
%config(noreplace) %_sysconfdir/papersize
%dir %_sysconfdir/libpaper.d
%_libdir/libpaper.so.*
%_man1dir/*
%_man5dir/*
%_man8dir/*

%if_enabled devel
%files devel
%_libdir/libpaper.so
%_includedir/paper.h
%_man3dir/*
%endif

%changelog
