%def_disable snapshot

%define rname pangomm
%define major 2.46
%define api_ver 1.4

%def_enable docs
%def_enable check

Name: lib%rname
Version: %major.3
Release: alt1

Summary: This library provides a C++ interface to pango
License: LGPL-2.1 and GPL-2.0
Group: System/Libraries
Url: http://gtkmm.sourceforge.net/

Conflicts: libgtkmm2 < 2.14.1

%if_enabled snapshot
Source: %rname-%version.tar
%else
Source: ftp://ftp.gnome.org/pub/gnome/sources/%rname/%major/%rname-%version.tar.xz
%endif

%define glib_ver 2.48.0
%define cairo_ver 1.2.2
%define pango_ver 1.46

BuildRequires(pre): meson
BuildRequires: mm-common gcc-c++
BuildRequires: libcairomm-devel >= %cairo_ver
BuildRequires: libglibmm-devel >= %glib_ver
BuildRequires: libpango-devel >= %pango_ver
%{?_enable_docs:BuildRequires: docbook-style-xsl doxygen graphviz xsltproc}

%description
This library provides a C++ interface to pango.

%package devel
Summary: Headers and development files of %name library
Group: Development/GNOME and GTK+
Requires: %name = %version-%release
Conflicts: libgtkmm2-devel < 2.14.1

%description devel
This package contains the headers and various development files needed
for compiling or development of applications that wants C++ interface
of %name library.

%package doc
Summary: %name documentation (html)
Group: Publishing
Requires: %name = %version-%release
BuildArch: noarch

%description doc
%name development documentation (html)

%prep
%setup -n %rname-%version

%build
%{?_enable_snapshot:mm-common-prepare -f}
%meson \
    %{?_enable_docs:-Dbuild-documentation=true} \
    %{?_enable_snapshot:-Dmaintainer-mode=true
    -Dbuild-documentation=true}
%nil
%meson_build

%install
%meson_install

%check
export LD_LIBRARY_PATH=%buildroot%_libdir
%meson_test

%files
%doc AUTHORS NEWS
%_libdir/*.so.*

%files devel
%_includedir/%rname-%api_ver
%_libdir/*.so
%_libdir/%rname-%api_ver
%_pkgconfigdir/*.pc

%if_enabled docs
%files doc
%_datadir/devhelp/books/%rname-%api_ver
%_docdir/%rname-%api_ver
%endif

%changelog
