%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

%def_enable spreadsheet-model
%def_with python
Name: liborcus
Version: 0.20.2
Release: alt1
Summary: Standalone file import filter library for spreadsheet documents

Group: System/Libraries
License: MPL-2.0
Url: https://gitlab.com/orcus/orcus
Source: orcus-%version.tar.gz

%define libver 0.20

BuildRequires: gcc-c++
BuildRequires: boost-devel-headers
BuildRequires: boost-filesystem-devel
BuildRequires: boost-interprocess-devel
BuildRequires: boost-program_options-devel
BuildRequires: libixion-devel >= 0.20.0
BuildRequires: mdds-devel >= 3.0.0
BuildRequires: python3-devel
BuildRequires: zlib-devel

%description
%name is a standalone file import filter library for spreadsheet
documents. Currently under development are ODS, XLSX and CSV import
filters.

%package devel
Summary: Development files for %name
Group: Development/C++

%description devel
The %name-devel package contains libraries and header files for
developing applications that use %name.

%package tools
Summary: Tools for working with Orcus
Group: Publishing

%description tools
Tools for working with Orcus.

%package -n python3-module-orcus
Summary: Python3 bindings for Orcus
Group:Development/Python3

%description -n python3-module-orcus
Python3 bindings for Orcus

%prep
%setup

%build
%add_optflags -D_FILE_OFFSET_BITS=64

sed -i 's|liborcus_@ORCUS_API_VERSION@_la_LIBADD = |& ../parser/liborcus-parser-@ORCUS_API_VERSION@.la|' src/liborcus/Makefile.am
sed -i 's/liborcus_parser_.*_la_LIBADD = /& $(BOOST_SYSTEM_LIB) /' src/parser/Makefile.am

%autoreconf

# TODO spreadsheet-model requires ixion
%configure \
	--disable-debug \
	--disable-static \
	--disable-werror \
	--with-pic \
	--with-boost \
	--with-boost-system \
	%subst_enable spreadsheet-model \
%if_without python
	--disable-python \
%endif
#

sed -i \
    -e 's|^hardcode_libdir_flag_spec=.*|hardcode_libdir_flag_spec=""|g' \
    -e 's|^runpath_var=LD_RUN_PATH|runpath_var=DIE_RPATH_DIE|g' \
    libtool

%make_build V=1

%install
make install DESTDIR=%buildroot
rm -f %buildroot/%_libdir/*.la
ln -s %name-%libver.pc %buildroot%_pkgconfigdir/%name.pc

%files
%doc AUTHORS
%_libdir/%name-*%libver.so.*

%files devel
%_includedir/%name-%libver
%_libdir/%name-*%libver.so
%_libdir/pkgconfig/%{name}*.pc

%files tools
%_bindir/orcus-*

%if_with python
%files -n python3-module-orcus
%python3_sitelibdir/*
%python3_sitelibdir_noarch/*
%endif

%changelog
