%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

# LTO causes errors, disable it
%global optflags_lto %nil

# TODO: remove later this fix for documentation
%define _cmake__builddir BUILD

%def_with openmp
%def_without unicap
%def_with swig
%def_with python3
%def_without octave
%def_without gstreamer
%def_with ffmpeg
%def_with 1394libs
%def_with v4l
%def_with gtk
%def_without quicktime
%ifarch %{ix86} x86_64 armh
%def_with gdcm
%else
%def_without gdcm
%endif
%def_without openni
#----------------------------------------------------------------------
%define set_without() %{expand:%%force_without %{1}} %{expand:%%undefine _with_%{1}}

%{?_with_ffmpeg:%set_without gstreamer}
%{?_with_ffmpeg:%set_without quicktime}
%{?_with_1394libs:%set_without quicktime}
%{?_with_v4l:%set_without quicktime}

%define bname opencv
%define Name OpenCV
%define sover 4.11
%define sover2 411
Name: lib%bname%sover
Epoch: 1
Version: 4.11.0
Release: alt3
Summary: Open Source Computer Vision Library
License: BSD-3-Clause AND Apache-2.0 AND ISC
Group: System/Libraries
URL: https://opencv.org
VCS: https://github.com/opencv/opencv.git
Source: %bname-%version.tar
# https://github.com/opencv/opencv_contrib.git
Source1: %bname-contrib-%version.tar
Source2: expected_mods.list
Source3: expected_mods_ppc64le_aarch64.list

Patch1: lib%bname-4.5.5-alt-python-paths.patch
Patch2: lib%bname-4.5.5-alt-build.patch
Patch3: libopencv-4.11.0-alt-cmake-compat.patch

Patch2000: lib%bname-e2k-simd.patch

BuildRequires: gcc-c++ libjasper-devel libjpeg-devel libtiff-devel
BuildRequires: openexr-devel graphviz libpng-devel libpixman-devel
BuildRequires: cmake eigen3 zlib-devel
BuildRequires: python3 python3(bs4) doxygen
BuildRequires: libucil-devel libtbb-devel bzlib-devel
BuildRequires: pkgconfig(glproto) pkgconfig(dri2proto) pkgconfig(xext)
BuildRequires: pkgconfig(xdamage) pkgconfig(xxf86vm)
BuildRequires: libGLU-devel libXau-devel libXdmcp-devel
BuildRequires: python3-module-sphinx-devel python3-module-Pygments python3-module-sphinx-sphinx-build-symlink
BuildRequires: texlive-latex-base
BuildRequires: libprotobuf-devel protobuf-compiler libwebp-devel
BuildRequires: libgflags-devel
BuildRequires: libflexiblas-devel
BuildRequires: libpcre2-devel
BuildRequires: libbrotli-devel
BuildRequires: libffi-devel
BuildRequires: libmount-devel
BuildRequires: libexpat-devel
BuildRequires: libavif-devel
BuildRequires: libblkid-devel
BuildRequires: libhdf5-devel

%ifarch %{ix86} x86_64 armh
BuildRequires: libglog-devel
%endif
%ifarch %{ix86} x86_64
BuildRequires: ceres-solver-devel
%endif
%{?_with_v4l:BuildRequires: libv4l-devel}
%{?_with_openmp:BuildRequires: libgomp-devel}
%{?_with_unicap:BuildRequires: libunicap-devel}
%{?_with_ffmpeg:BuildRequires: libavformat-devel libswscale-devel libswresample-devel}
%{?_with_gstreamer:BuildRequires: gstreamer1.0-devel gst-plugins1.0-devel}
%{?_with_gtk:BuildRequires: libgtk+3-devel}
%{?_with_python3:
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel
BuildRequires: libnumpy-py3-devel
}
%{?_with_octave:BuildRequires: octave-devel}
%{?_with_swig:BuildRequires: swig}
%{?_with_1394libs:BuildRequires: libdc1394-devel}
%{?_with_gdcm:BuildRequires: gdcm-devel}
%{?_with_openni:
BuildRequires: openni-devel
BuildRequires: openni-primesense
}
BuildRequires: libade-devel

%add_findprov_skiplist %_datadir/OpenCV/samples/*

%description
%Name means Intel(R) Open Source Computer Vision Library. It is a
collection of C functions and a few C++ classes that implement many
popular Image Processing and Computer Vision algorithms.
%Name provides cross-platform middle-to-high level API that includes
about 300 C functions and a few C++ classes. Also there are constantly
improving Python bindings to %Name.

%prep
%setup -b 1
%patch1 -p1
%patch2 -p1
%patch3 -p1
%ifarch %e2k
%patch2000 -p1
%endif

rm -fR 3rdparty/{ffmpeg,libjasper,libjpeg,libpng,libtiff,openexr,tbb,zlib,protobuf,libwebp}

%build
%add_optflags -D_FILE_OFFSET_BITS=64 -DGLOG_USE_GLOG_EXPORT

%cmake \
	-DBUILD_PACKAGE:BOOL=ON \
	-DBUILD_TESTS:BOOL=OFF \
	-DBUILD_EXAMPLES:BOOL=OFF \
	-DINSTALL_C_EXAMPLES:BOOL=OFF \
	-DINSTALL_PYTHON_EXAMPLES:BOOL=OFF \
	-DENABLE_OPENMP:BOOL=%{?_with_openmp:ON}%{!?_with_openmp:OFF} \
	-DWITH_TBB:BOOL=ON \
	-DBUILD_PYTHON_SUPPORT:BOOL=ON \
	-DCMAKE_VERBOSE:BOOL=ON \
	-DCMAKE_VERBOSE_MAKEFILE:BOOL=ON \
	-DCMAKE_BUILD_TYPE:STRING=RelWithDebInfo \
	-DWITH_UNICAP:BOOL=%{?_with_unicap:ON}%{!?_with_unicap:OFF} \
	-DWITH_QUICKTIME:BOOL=%{?_with_quicktime:ON}%{!?_with_quicktime:OFF} \
	-DWITH_FFMPEG:BOOL=%{?_with_ffmpeg:ON}%{!?_with_ffmpeg:OFF} \
	-DWITH_GSTREAMER=%{?_with_gstreamer:ON}%{!?_with_gstreamer:OFF} \
	-DWITH_OPENGL:BOOL=ON \
	-DCMAKE_STRIP:FILEPATH="/bin/echo" \
	-DBUILD_opencv_ts:BOOL=OFF \
	-DBUILD_PROTOBUF:BOOL=OFF \
	-DPROTOBUF_UPDATE_FILES:BOOL=ON \
	-DOPENCV_ENABLE_NONFREE:BOOL=ON \
	-DWITH_LIBV4L:BOOL=%{?_with_v4l:ON}%{!?_with_v4l:OFF} \
	-DOPENCV_EXTRA_MODULES_PATH=%_builddir/%bname-contrib-%version/modules \
	%{?_with_openni: -DWITH_OPENNI=ON } \
	%{?_with_gdcm: -DWITH_GDCM=ON} \
	-DBUILD_DOCS:BOOL=ON \
	-DOPENCV_DOC_INSTALL_PATH=%_docdir/%name/ \
	-DOPENCV_3P_LIB_INSTALL_PATH=%_libdir/%Name/3rdparty/%_lib \
	-DOPENCV_LICENSES_INSTALL_PATH=%_datadir/%Name-%version/licenses \
	-DOPENCV_OTHER_INSTALL_PATH=%_datadir/%Name \
	-DOPENCV_GENERATE_PKGCONFIG:BOOL=ON \
	-DOPENCV_SKIP_CMAKE_CXX_STANDARD:BOOL=ON \
	-DPYTHON_EXECUTABLE=%__python3 \
	-DPYTHON_DEFAULT_EXECUTABLE=%__python3 \
        %ifarch %ix86
        -DCPU_DISPATCH= \
        %endif
	%nil

%cmake_build
%cmake_build -t opencv_docs

%install
%cmakeinstall_std install_docs

# compare expected provides against actual modules
# fill the list of actual modules
PYTHONPATH=%buildroot%python3_sitelibdir \
LD_LIBRARY_PATH=%buildroot%_libdir:$LD_LIBRARY_PATH \
python3 - <<-'EOF' | sort -u > actual_mods.list
import importlib
import inspect

import cv2

def predicate(obj):
    return inspect.ismodule(obj) and obj.__name__.startswith("cv2.")


def find_mods(mod_name, found_mods=set()):
    mod = importlib.import_module(mod_name)
    for x in inspect.getmembers(mod, predicate):
        mod_name_cand = x[1].__name__
        if mod_name_cand not in found_mods:
            found_mods.add(mod_name_cand)
            find_mods(mod_name_cand, found_mods)


found_mods = set()
find_mods("cv2", found_mods)
for mod in found_mods:
    print(mod)
EOF

%ifarch x86_64
    sort %SOURCE2 > expected_mods.list
    diff -y expected_mods.list actual_mods.list ||
	{ echo 'Update expected list of modules' ; exit 1 ; }
%endif
%ifarch ppc64le aarch64
    sort %SOURCE3 > expected_mods.list
    diff -y expected_mods.list actual_mods.list ||
	{ echo 'Update expected list of modules' ; exit 1 ; }
%endif

%files
%doc README.md
%_libdir/*.so.%sover.*
%_libdir/*.so.%sover2
%dir %_datadir/%Name
%dir %_datadir/%Name-%version
%_datadir/%Name-%version/licenses


%changelog
