%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

Name: libntirpc
Version: 7.2
Release: alt1
Summary: New Transport Independent RPC Library
Group: System/Libraries
License: BSD-3-Clause
Url: https://github.com/nfs-ganesha/ntirpc

Source: %name-%version.tar
BuildRequires(pre): rpm-macros-cmake
BuildRequires: cmake
BuildRequires: gcc-c++
BuildRequires: libkrb5-devel
BuildRequires: libnsl2-devel
BuildRequires: libuserspace-rcu-devel
BuildRequires: ninja-build

# libtirpc has /etc/netconfig, most machines probably have it anyway
# for NFS client
Requires: libtirpc

%description
This package contains a new implementation of the original libtirpc,
transport-independent RPC (TI-RPC) library for NFS-Ganesha. It has
the following features not found in libtirpc:
 1. Bi-directional operation
 2. Full-duplex operation on the TCP (vc) transport
 3. Thread-safe operating modes
 3.1 new locking primitives and lock callouts (interface change)
 3.2 stateless send/recv on the TCP transport (interface change)
 4. Flexible server integration support
 5. Event channels (remove static arrays of xprt handles, new EPOLL/KEVENT
    integration)

%package devel
Summary: Development headers for %name
Requires: %name = %EVR
Group: Development/C
AutoReq: nocpp

%description devel
Development headers and auxiliary files for developing with %name.

%prep
%setup
# Setting LIB_INSTALL_DIR (in %%cmake) breaks libdir= path in libntirpc.pc but
# because they don't use it later thus it affects nothing so lets not fix it.

%build
%add_optflags %(getconf LFS_CFLAGS)
%cmake \
    -DTIRPC_EPOLL=1 \
    -DUSE_GSS=ON \
    -DUSE_MONITORING=OFF \
    -GNinja

%cmake_build

%install
%cmake_install
# man-pages duplicate libtirpc-devel, so not installed.
# tests/ contain sole rpcping binary which is not installed and isn't a test
# (also having incorrect rpath).

%files
# NEWS and ChangeLog are very old and suggest to view git log.
%doc AUTHORS COPYING THANKS README
%_libdir/libntirpc.so.%version

%files devel
%_libdir/libntirpc.so
%_includedir/ntirpc
%_pkgconfigdir/libntirpc.pc

%changelog
