%def_disable snapshot
%define _name nice
%define ver_major 0.1
%define api_ver %ver_major
%define gst_api_ver 1.0

# old gupnp-igd-1.0 required
%def_disable gupnp
%def_enable gstreamer
%def_enable gtk_doc
# in hasher:
#32/44 test-set-port-range           FAIL            0.02s   killed by signal 6 SIGABRT
#33/44 test-slow-resolving           FAIL            0.01s   killed by signal 6 SIGABRT
%def_disable check

Name: libnice
Version: %ver_major.23
Release: alt1

Summary: Connectivity Establishment standard (ICE) library
Group: System/Libraries
License: LGPL-2.0-or-later and MPL-1.1
Url: https://nice.freedesktop.org

Vcs: https://gitlab.freedesktop.org/libnice/libnice.git

%if_disabled snapshot
Source: https://nice.freedesktop.org/releases/%name-%version.tar.gz
%else
Source: %name-%version.tar
%endif

%define glib_ver 2.54
%define gi_ver 1.30
%define tls_ver 2.12.0

BuildRequires(pre): rpm-macros-meson rpm-macros-valgrind
BuildRequires: meson glib2-devel >= %glib_ver
BuildRequires: gobject-introspection-devel >= %gi_ver
BuildRequires: libgnutls-devel
%{?_enable_gtk_doc:BuildRequires: gtk-doc %_bindir/dot}
%{?_enable_gupnp:BuildRequires: pkgconfig(gupnp-igd-1.0)}
%{?_enable_gstreamer:BuildRequires: gst-plugins%gst_api_ver-devel}
%{?_enable_check:
%{?_enable_gstreamer:BuildRequires: gstreamer1.0-utils gst-plugins-base%gst_api_ver}
%ifarch %valgrind_arches
BuildRequires: valgrind
%endif
}

%description
Nice is an implementation of the IETF's draft Interactice Connectivity
Establishment standard (ICE). It provides GLib-based library, libnice.

%package devel
Summary: Development files for %name
Group: Development/C
Requires: %name = %EVR

%description devel
Nice is an implementation of the IETF's draft Interactice Connectivity
Establishment standard (ICE). It provides GLib-based library, libnice.

This package contains files needed to develop applications using Nice

%package devel-doc
Summary: Development documentation for %name
Group: Development/C
Conflicts: %name < %version
BuildArch: noarch

%description devel-doc
Nice is an implementation of the IETF's draft Interactice Connectivity
Establishment standard (ICE). It provides GLib-based library, libnice.

This package contains development documentation for %name.

%package gir
Summary: GObject introspection data for the Nice library
Group: System/Libraries
Requires: %name = %EVR

%description gir
GObject introspection data for the Nice library.

%package gir-devel
Summary: GObject introspection devel data for the Nice library
Group: Development/Other
BuildArch: noarch
Requires: %name-gir = %EVR
Requires: %name-devel = %EVR

%description gir-devel
GObject introspection devel data for the Nice library.

%package devel-static
Summary: Static library for %name
Group: Development/C
Requires: %name-devel = %EVR

%description devel-static
Nice is an implementation of the IETF's draft Interactice Connectivity
Establishment standard (ICE). It provides GLib-based library, libnice.

This package contains a statically-linked variant of %name

%package -n gst-plugins-nice
Summary: UDP connectivity establishment plugin for Gstreamer based on libnice
Group: System/Libraries
Requires: %name = %EVR

%description -n gst-plugins-nice
Nice is an implementation of the IETF's draft Interactice Connectivity
Establishment standard (ICE). It provides GLib-based library, libnice.

This package provides Interactive UDP connectivity establishment plugin
for Gstreamer

%package -n gst-plugins-nice%gst_api_ver
Summary: UDP connectivity establishment plugin for Gstreamer (1.0) based on libnice
Group: System/Libraries
Requires: %name = %EVR

%description -n gst-plugins-nice%gst_api_ver
Nice is an implementation of the IETF's draft Interactice Connectivity
Establishment standard (ICE). It provides GLib-based library, libnice.

This package provides Interactive UDP connectivity establishment plugin
for Gstreamer (1.0 API version)

%package tools
Summary: libnice tools
Group: System/Libraries
Requires: %name = %EVR

%description tools
Nice is an implementation of the IETF's draft Interactice Connectivity
Establishment standard (ICE). It provides GLib-based library, libnice.

This package provides tools from libnice package.


%prep
%setup

%build
%meson \
    %{subst_enable_meson_feature gupnp gupnp} \
    %{subst_enable_meson_feature gstreamer gstreamer} \
    %{subst_enable_meson_feature gtk_doc gtk_doc}
%nil
%meson_build

%install
%meson_install

%check
%__meson_test

%files
%_libdir/*.so.*
%doc AUTHORS NEWS README

%files devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*

%if_enabled gtk_doc
%files devel-doc
%_datadir/gtk-doc/html/*
%endif

%if_enabled static
%files devel-static
%_libdir/*.a
%endif

%files gir
%_typelibdir/Nice-%api_ver.typelib

%files gir-devel
%_girdir/Nice-%api_ver.gir

%if_enabled gstreamer
%files -n gst-plugins-nice%gst_api_ver
%_libdir/gstreamer-%gst_api_ver/libgstnice.so
%endif

%files tools
%_bindir/stun*


%changelog
