Name: libmng
Version: 2.0.3
Release: alt3

Summary: A library for handling MNG files
License: Zlib
Group: System/Libraries
Url: https://sourceforge.net/projects/libmng/

# http://downloads.sourceforge.net/libmng/libmng-%version.tar.bz2
Source: libmng-%version.tar
Patch1: libmng-1.0.10-alt-build-fixes.patch
Patch2: libmng-1.0.10-alt-player-build.patch
Patch3: libmng-2.0.3-debian-linux-makefile.patch
BuildRequires: gcc-c++ libjpeg-devel liblcms2-devel zlib-devel

%package devel
Summary: Include files for development with %name
Group: Development/C
Requires: %name = %version-%release

%description
The MNG library supports decoding, displaying, encoding, and various
other manipulations of the Multiple-image Network Graphics (MNG) format
image files. It uses the zlib compression library, and optionally the
JPEG library by the Independent JPEG Group (IJG) and/or lcms (little cms),
a color-management library by Marti Maria Saguar.

%description devel
The MNG library supports decoding, displaying, encoding, and various
other manipulations of the Multiple-image Network Graphics (MNG) format
image files. It uses the zlib compression library, and optionally the
JPEG library by the Independent JPEG Group (IJG) and/or lcms (little cms),
a color-management library by Marti Maria Saguar.

This package contains include files required for development %name-based
applications.

%prep
%setup
%patch1 -p1
%patch2 -p1
%patch3 -p1

%build
cp makefiles/Makefile.am .
%autoreconf
%configure --enable-shared --disable-static \
	--with-zlib --with-jpeg --with-lcms
%make_build

%install
mkdir -p %buildroot%_mandir/man{3,5}
%makeinstall

pushd doc/man
	install -pm644 *.3 %buildroot%_man3dir/
	install -pm644 *.5 %buildroot%_man5dir/
popd

%files
%_libdir/*.so.*
%_man5dir/*
%doc CHANGES LICENSE README README.contrib README.examples
%doc doc/*.* contrib/gcc/gtk-mng-view/*.mng

%files devel
%_libdir/*.so
%_includedir/*
%_pkgconfigdir/*.pc
%_mandir/man3/*

%changelog
