# Unpackaged files in buildroot should terminate build
%define _unpackaged_files_terminate_build 1

Name: liblxqt
Version: 2.3.0
Release: alt1

Summary: Core utility library for LxQt components
License: LGPL-2.1
Group: Graphical desktop/Other

Url: https://github.com/lxqt/liblxqt
Source: %name-%version.tar
Patch: %name-%version-%release.patch

BuildRequires: gcc-c++ cmake rpm-macros-cmake
BuildRequires: qt6-base-devel qt6-tools-devel
# qt6-x11extras-devel
BuildRequires: kf6-kwindowsystem-devel
BuildRequires: lxqt2-build-tools libqt6xdg-devel
BuildRequires: libXScrnSaver-devel
BuildRequires: libpolkitqt6-qt6-devel
BuildRequires: pkgconfig(glib-2.0)
BuildRequires: pkgconfig(gio-unix-2.0)

Requires: qt6-svg

Provides: librazorqt = %version
Obsoletes: librazorqt < 0.7.0

Provides: %name-data = %version
Obsoletes: %name-data < 0.11.0
Obsoletes: lxqt-backlight_backend < %EVR
Obsoletes: lxqt-l10n < %EVR

%description
%summary.

%package devel
Summary: Development headers for LXQt library
Group: Development/C++
Requires: %name = %version
Requires: lxqt2-build-tools

%description devel
This package provides the development files for LXQt library.

%prep
%setup
%patch -p1

%build
%cmake -DUPDATE_TRANSLATIONS=ON
%cmake_build

%install
%cmake_install

%files
%_libdir/*.so.*
%doc AUTHORS CHANGELOG COPYING README.md
%_bindir/lxqt-backlight_backend
%dir %_datadir/lxqt
%_datadir/lxqt/*
%_datadir/polkit-1/actions/org.lxqt.backlight.pkexec.policy

%files devel
%_libdir/*.so
%_includedir/*/
%_pkgconfigdir/*.pc
%_datadir/cmake/*/

%changelog
