# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-mageia-compat
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# %%name is ahead of its definition. Predefining for rpm 4.0 compatibility.
%define name liblscp
%define major       6
%define libname     lib%{oname}%{major}
%define develname   lib%{oname}-devel
%define docname     %name-docs

%define oname       lscp

Name:          liblscp
Summary:       LinuxSampler Control Protocol (LSCP) wrapper library
Version:       1.0.1
Release:       alt1_1
License:       LGPLv2
Group:         System/Libraries
URL:           https://www.linuxsampler.org/
Source0:       https://sourceforge.net/projects/qsampler/files/liblscp/%{version}/%{name}-%{version}.tar.gz

BuildRequires: ccmake cmake ctest
BuildRequires: doxygen
Source44: import.info

%description
LinuxSampler Control Protocol (LSCP) wrapper library.

#--------------------------------------------------------------------

%package -n     %libname
Summary:        Libraries for %name
Group:          System/Libraries
Provides:       %name = %version-%release

%description -n %libname
LinuxSampler Control Protocol (LSCP) wrapper library.

%files -n %libname
%{_libdir}/liblscp.so.%{major}
%{_libdir}/liblscp.so.%{major}.*

#--------------------------------------------------------------------

%package -n     %develname
Summary:        Development libraries for %name
Group:          Development/Other
Requires:       %libname = %{version}-%{release}
Provides:       %{name}-devel = %{version}-%{release}
Provides:       %{oname}-devel = %{version}-%{release}

%description -n %develname
Development libraries from %oname.

%files -n %develname
%doc --no-dereference LICENSE
%dir %{_includedir}/lscp
%{_includedir}/lscp/*.h
%{_libdir}/liblscp.so
%{_libdir}/pkgconfig/lscp.pc

#------------------------------------------------------------------

%package -n     %docname
Group:          Development/Other
Summary:        Docs for %name
BuildArch:      noarch
Provides:       %{oname}-docs = %{version}-%{release}

%description -n %docname
Docs for %oname.

%files -n %docname
%dir %{_docdir}/%{name}
%{_docdir}/%{name}/html

#--------------------------------------------------------------------

%prep
%setup -q


%build
%{mageia_cmake} -DCMAKE_INSTALL_PREFIX=%{_usr} \
       -DCMAKE_INSTALL_LIBDIR=%{_lib}

%mageia_cmake_build

%install
%mageia_cmake_install


%changelog
