%define _name kpmcore
%define xdg_name org.kde.%_name
%define _libexecdir %_prefix/libexec

Name: lib%_name
Version: 25.08.3
Release: alt1

Summary: KDE Partition Manager core library
Group: System/Libraries
License: GPL-3.0-or-later
Url: https://github.com/KDE/%_name

Vcs: https://github.com/KDE/kpmcore.git

Source: https://download.kde.org/stable/release-service/%version/src/%_name-%version.tar.xz
#Source: %url/archive/v%version/%_name-%version.tar.gz

Provides: %_name = %EVR

%define blkid_ver 2.30
%define ecm_ver 5.240.0
%define qt_ver 6.5.0

Requires: sfdisk polkit ntfs-3g exfatprogs btrfs-progs

BuildRequires(pre): rpm-build-kf6
BuildRequires: gcc-c++ extra-cmake-modules >= %ecm_ver
BuildRequires: %_bindir/appstreamcli
#BuildRequires: libdbus-devel libatasmart-devel libblkid-devel >= %blkid_ver libparted-devel
#BuildRequires: kf6-ki18n-devel kf6-kiconthemes-devel kf6-kio-devel libqca-qt6-devel
#BuildRequires: libpolkitqt6-qt6-devel
BuildRequires: pkgconfig(blkid) >= %blkid_ver
BuildRequires: pkgconfig(libparted)
BuildRequires: pkgconfig(Qt6Core) >= %qt_ver
BuildRequires: pkgconfig(Qt6DBus)
BuildRequires: pkgconfig(Qt6Gui)
BuildRequires: pkgconfig(polkit-qt6-core-1)
#BuildRequires: pkgconfig(KF6I18n)
BuildRequires: kf6-ki18n-devel
#BuildRequires: pkgconfig(KF6CoreAddons)
BuildRequires: kf6-kcoreaddons-devel
#BuildRequires: pkgconfig(KF6WidgetsAddons)
BuildRequires: kf6-kwidgetsaddons-devel

%description
%_name is a Library for managing partitions. Common code for KDE
Partition Manager and other projects.

%package devel
Summary: Development files for icclib
Group: Development/C
Requires: %name = %EVR
Provides: %_name-devel = %EVR

%description devel
%_name is a Library for managing partitions. Common code for KDE
Partition Manager and other projects.

This package provides headers and libraries for development applications
using %_name.

%prep
%setup -n %_name-%version

%build
%K6build

%install
%K6install
%find_lang --all-name %_name

%files -f %_name.lang
%_libexecdir/%{_name}_externalcommand
%_datadir/dbus-1/system-services/%xdg_name.helperinterface.service
%_datadir/dbus-1/system.d/%xdg_name.helperinterface.conf
%_K6lib/*.so.*
%_K6plug/%_name/*.so
%_datadir/polkit-1/actions/%xdg_name.externalcommand.policy

%files devel
#%_K6inc/%_name/
%_includedir/%_name
%_K6lib/cmake/KPMcore/
%_K6link/*.so


%changelog
