%def_disable snapshot
%define _libexecdir %_prefix/libexec

%define _name json-glib
%define ver_major 1.10
%define api_ver 1.0
%define namespace Json

%def_disable symbol_versioning
%def_enable doc
%def_enable man
%def_enable introspection
%def_enable installed_tests
%def_enable check

Name: lib%_name
Version: %ver_major.8
Release: alt1

Summary: GLib-based JSON manipulation library
Group: System/Libraries
License: LGPL-2.1-or-later
Url: https://wiki.gnome.org/Projects/JsonGlib

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%_name/%ver_major/%_name-%version.tar.xz
%else
Source: %_name-%version.tar
%endif
# https://gitlab.gnome.org/GNOME/json-glib/-/issues/33
# --default-symver breaks set-versioned dependencies, revert it
Patch1: json-glib-1.6.4-alt-remove_symbol_versioning.patch

%define glib_ver 2.72
%define gi_ver 1.72

BuildRequires(pre): rpm-macros-meson
BuildRequires: meson glib2-devel >= %glib_ver
%{?_enable_static:BuildRequires: glibc-devel-static}
%{?_enable_introspection:BuildRequires: gobject-introspection-devel >= %gi_ver}
%{?_enable_doc:BuildRequires: gi-docgen}
%{?_enable_man:BuildRequires: /usr/bin/rst2man}

%description
JSON-GLib implements a full JSON parser using GLib and GObject. Use
JSON-GLib it is possible to parse and generate valid JSON data
structures, using a DOM-like API. JSON-GLib also offers GObject
integration, providing the ability to serialize and deserialize GObject
instances to and from JSON data types.

%package devel
Summary: Development files for %_name
Group: Development/C
Requires: %name = %EVR

%description devel
The %name-devel package contains libraries and header files for
developing applications that use %name.

%package gir
Summary: GObject introspection data for the JSON-GLib library
Group: System/Libraries
Requires: %name = %EVR

%description gir
GObject introspection data for the JSON-GLib library

%package gir-devel
Summary: GObject introspection devel data for the JSON-GLib library
Group: System/Libraries
BuildArch: noarch
Requires: %name-gir = %EVR

%description gir-devel
GObject introspection devel data for the JSON-GLib library

%package devel-doc
Summary: Development package for JSON-GLib
Group: Development/Documentation
BuildArch: noarch
Conflicts: lib%name < %version

%description devel-doc
This package contains developer documentation for the JSON-GLib library.

%package tests
Summary: Tests for the %_name package
Group: Development/Other
Requires: %name = %EVR

%description tests
This package provides tests programs that can be used to verify
the functionality of the installed %_name library.

%prep
%setup -n %_name-%version
%{?_disable_symbol_versioning:%patch1 -p1 -b .symver}

%build
%meson \
    %{subst_enable_meson_feature introspection introspection} \
    %{subst_enable_meson_feature doc documentation} \
    %{subst_enable_meson_bool man man} \
    %{subst_enable_meson_bool installed_tests installed_tests}
%nil
%meson_build

%install
%meson_install
%find_lang --output=%_name.lang %_name-%api_ver

%check
%__meson_test

%files -f %_name.lang
%_bindir/%_name-format
%_bindir/%_name-validate
%_libdir/*.so.*
%if_enabled man
%_man1dir/%_name-format.1.*
%_man1dir/%_name-validate.1.*
%endif
%doc NEWS README.md

%files devel
%_libdir/*.so
%_includedir/%_name-%api_ver/
%_pkgconfigdir/%_name-%api_ver.pc

%if_enabled introspection
%files gir
%_typelibdir/%namespace-%api_ver.typelib

%files gir-devel
%_girdir/%namespace-%api_ver.gir
%endif

%if_enabled doc
%files devel-doc
%_datadir/doc/%_name-%api_ver
%endif

%if_enabled installed_tests
%files tests
%_libexecdir/installed-tests/%_name-%api_ver/
%_datadir/installed-tests/%_name-%api_ver/
%endif

%changelog
