%define title jemalloc
%define sorev 2

%def_with check

Name: libjemalloc2
Version: 5.3.0
Release: alt2.1
Summary: A general-purpose scalable concurrent malloc(3) implementation
Group: System/Libraries
License: BSD
Url: http://jemalloc.net/
VCS: https://github.com/jemalloc/jemalloc

Source: %name-%version.tar
Patch: %name-%version-alt.patch

# Automatically added by buildreq on Mon May 14 2018
# optimized out: glibc-kernheaders-generic glibc-kernheaders-x86 gnu-config libstdc++-devel python-base
BuildRequires: gcc-c++
BuildRequires: xsltproc docbook-style-xsl

%if_with check
BuildRequires: /proc
%endif

%description
jemalloc is a general-purpose scalable concurrent malloc(3)
implementation. There are several divergent versions of jemalloc in
active use, including:

 * FreeBSD's default system allocator (malloc.c, manual page). This was
    the first public use of jemalloc, and it is still author-maintained.
 * NetBSD's default system allocator (jemalloc.c).
 * Mozilla Firefox's allocator (source code), specifically for
   Microsoft Windows-related platforms, Solaris, and Linux. There is
   Apple Mac OS X support code as well, but it has never been used in a
   release.
 * The stand-alone jemalloc, which currently targets only Linux.
   Thus far I have had no driving need to integrate support for other
   operating systems into this version of jemalloc, but it is probable
   that the stand-alone jemalloc library's platform support will
    broaden over time.

%package -n libjemalloc-tools
Summary: Shell wrapper  for preloading %title
Group: System/Libraries
License: BSD
Requires: %name = %EVR

%description -n libjemalloc-tools
Starting up wrapper for use %title.

%package -n libjemalloc-devel
Summary: Development files of %title
Group: System/Libraries
License: BSD

%description -n libjemalloc-devel
Development files of %title

%prep
%setup
%autopatch -p1

%build
%autoreconf

%configure \
    --with-version='%version-0-g0' \
    --with-xslroot=/usr/share/xml/docbook/xsl-stylesheets \
%ifarch %e2k
    --with-lg-quantum=4 \
%endif
    %nil

%make_build
%make doc

%install
%makeinstall_std

mv %buildroot%_defaultdocdir/jemalloc{,%sorev}

# add so.2 -> so.2.0
mv %buildroot%_libdir/libjemalloc.so.%sorev{,.0}
ln -s libjemalloc.so.%sorev.0 %buildroot%_libdir/libjemalloc.so.%sorev

rm -r %buildroot%_libdir/*.a

%check
%make_build VERBOSE=1 check

%files
%doc %_defaultdocdir/jemalloc2
%doc COPYING README TUNING* VERSION
%_libdir/libjemalloc.so.%sorev
%_libdir/libjemalloc.so.%sorev.0

%files -n libjemalloc-tools
%_bindir/jemalloc.sh

%files -n libjemalloc-devel
%_bindir/*prof
%_includedir/*
%_man3dir/*
%_libdir/libjemalloc.so
%_bindir/*config
%_pkgconfigdir/*.pc

%changelog
