Name: libheif
Version: 1.20.2
Release: alt1

Summary: HEIF file format decoder and encoder
License: LGPLv3
Group: System/Libraries

Url: https://github.com/strukturag/libheif
Packager: Valery Inozemtsev <shrek@altlinux.ru>

Source: %name-%version.tar
Patch: %name-%version-alt.patch

BuildRequires: cmake ctest gcc-c++ libde265-devel libjpeg-devel libpng-devel libtiff-devel libwebp-devel libgdk-pixbuf-devel libaom-devel
BuildRequires: libkvazaar-devel libopenjpeg2.0-devel openjpeg-tools2.0 libavcodec-devel libopenh264-devel libsvt-av1-devel libx265-devel
%ifnarch %e2k
BuildRequires: librav1e-devel libdav1d-devel
%endif

%description
HEIF is a new image file format employing HEVC (h.265) image coding for the
best compression ratios currently possible.

%package devel
Group: Development/C
Summary:  Development libraries for %name

%description devel
Development libraries for %name

%prep
%setup
%patch -p1
%ifarch %e2k
sed -i 's/-Werror/-Wno-error/g' CMakeLists.txt
%endif

%build
%cmake \
	-DWITH_UNCOMPRESSED_CODEC=ON \
	-DPLUGIN_DIRECTORY=%_libdir/libheif/plugins \
	-DWITH_OpenH264_DECODER=ON \
	-DWITH_X265_PLUGIN=ON \
	-DWITH_FFMPEG_DECODER=ON \
	-DWITH_FFMPEG_DECODER_PLUGIN=ON \
	-DWITH_AOM_DECODER_PLUGIN=ON \
	-DWITH_AOM_ENCODER_PLUGIN=ON \
	-DWITH_DAV1D=ON \
	-DWITH_DAV1D_PLUGIN=ON \
	-DWITH_RAV1E=ON \
	-DWITH_RAV1E_PLUGIN=ON \
	-DWITH_JPEG_DECODER=ON \
	-DWITH_JPEG_DECODER_PLUGIN=ON \
	-DWITH_JPEG_ENCODER=ON \
	-DWITH_JPEG_ENCODER_PLUGIN=ON \
	-DWITH_KVAZAAR=ON \
	-DWITH_KVAZAAR_PLUGIN=ON \
	-DWITH_LIBDE265_PLUGIN=ON \
	-DWITH_LIBSHARPYUV=ON \
	-DWITH_OpenJPEG_DECODER=ON \
	-DWITH_OpenJPEG_DECODER_PLUGIN=ON \
	-DWITH_OpenJPEG_ENCODER=ON \
	-DWITH_OpenJPEG_ENCODER_PLUGIN=ON \
	-DWITH_SvtEnc=ON \
	-DWITH_SvtEnc_PLUGIN=ON

%cmake_build

%check
%ctest

%install
%cmake_install

%files
%_bindir/*
%_libdir/%name.so.*
%_libdir/%name
%_libdir/gdk-pixbuf-2.0/2.10.0/loaders/*.so*
%_datadir/thumbnailers/heif.thumbnailer
%_man1dir/*.1*

%files devel
%_includedir/%name
%_libdir/%name.so
%_libdir/cmake/%name
%_pkgconfigdir/%name.pc

%changelog
