%define _name gtksourceview
%define ver_major 2.11
%define namespace GtkSource
%define api_ver 2.0
%def_disable static
%def_disable gtk_doc
%def_disable introspection
%def_disable check

Name: lib%{_name}
Version: %ver_major.2
Release: alt3.1

Summary: GtkSourceView text widget library
License: LGPL-2.1-or-later
Group: System/Libraries
Url: http://www.gnome.org

Vcs: https://gitlab.gnome.org/GNOME/gtksourceview.git

Source: %gnome_ftp/%_name/%ver_major/%_name-%version.tar.gz
Source1: %name-2.10.map
Patch: %name-2.9.4-alt-symver.patch
Patch1: %name-2.11.2-alt-tests-deprecation.patch
Patch2: %_name-2.11.2-alt-no-gtk3.patch

# fc patches
Patch10: %_name-2.11.2-cflags.patch
# https://bugzilla.redhat.com/show_bug.cgi?id=672823
Patch11: %_name-2.11-fix-GCONST-def.patch
Patch12: %_name-2.11-add-libs.patch
Patch13: %_name-2.11-glib-unicode-constant.patch

Provides: %{name}2 = %EVR
Obsoletes: %{name}2 < %version-%release

# From configure.ac
%define intltool_ver 0.35
%define gtk_ver 2.12.0
%define libxml2_ver 2.5.0

BuildRequires(pre): rpm-build-gnome rpm-build-python rpm-build-gir

# From configure.ac
BuildPreReq: intltool >= %intltool_ver
BuildPreReq: gnome-common
BuildPreReq: libgtk+2-devel >= %gtk_ver
BuildPreReq: libxml2-devel >= %libxml2_ver
BuildPreReq: libGConf-devel
BuildPreReq: gtk-doc >= 1.0

BuildRequires: gcc-c++ perl-XML-Parser zlib-devel libgio-devel libcairo-gobject-devel
BuildRequires: gobject-introspection-devel
%{?_enable_introspection:BuildRequires: libgtk+2-gir-devel}
%{?_enable_cheeck:BuildRequires: xvfb-run}

%description
GtkSourceView is a text widget that extends the standard gtk+ 2.x text
widget GtkTextView. It improves GtkTextView by implementing syntax
highlighting and other features typical of a source editor.

This package contains shared GtkSourceView library.

%package devel
Summary: Files to compile applications that use GtkSourceView
Group: Development/GNOME and GTK+
Requires: %name = %EVR
Provides: %{name}2-devel = %EVR
Obsoletes: %{name}2-devel < %version-%release

%description devel
This package contains the files required to develop applications against
the GtkSourceView library.

%package devel-doc
Summary: Development documentation for %_name
Group: Development/GNOME and GTK+
Conflicts: %name < %version-%release
BuildArch: noarch

%description devel-doc
GtkSourceView is a text widget that extends the standard gtk+ 2.x text
widget GtkTextView. It improves GtkTextView by implementing syntax
highlighting and other features typical of a source editor.

This package provides development documentation for %_name.

%package gir
Summary: GObject introspection data for the GtkSourceView library
Group: System/Libraries
Requires: %name = %EVR

%description gir
GObject introspection data for the GtkSourceView library

%package gir-devel
Summary: GObject introspection devel data for the GtkSourceView library
Group: System/Libraries
BuildArch: noarch
Requires: %name-gir = %EVR

%description gir-devel
GObject introspection devel data for the GtkSourceView library

%define _gtk_docdir %_datadir/gtk-doc/html

%prep
%setup -n %_name-%version
install -p -m644 %SOURCE1 gtksourceview/libgtksourceview.map
%patch
%patch1
%patch2 -b .no-gtk3
%patch10 -p1
%patch11 -p1
%patch12 -p1
%patch13 -p1

# fix shebang: python -> python2
sed -i 's|\(#\!/usr/bin/env python\)$|\12|' data/language-specs/convert.py

%build
%add_optflags -Wno-error=format-nonliteral -Wno-deprecated-declarations -Wno-incompatible-pointer-types
%autoreconf
%configure \
    %{subst_enable static} \
    %{?_enable_gtk_doc:--enable-gtk-doc} \
    %{subst_enable introspection} \
    --enable-deprecations=no
%nil
%make_build

%check
export LANG=en_US.UTF-8
xvfb-run %make -k check VERBOSE=1

%install
%makeinstall_std
%find_lang %_name-%api_ver

%files -f %_name-%api_ver.lang
%_libdir/*.so.*
%_datadir/%_name-%api_ver
%doc AUTHORS ChangeLog NEWS README

%files devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*
%doc HACKING MAINTAINERS

%files devel-doc
%_gtk_docdir/*

%if_enabled introspection
%files gir
%_typelibdir/%namespace-%api_ver.typelib

%files gir-devel
%_girdir/%namespace-%api_ver.gir
%endif


%changelog
