%set_automake_version 1.10

%define ver_major 2.20
%define _name gtk-engines
%define engine_prefix libgtk-engine
%define old_engine_prefix gtk-engines
%define engine_namechange_ver 2.8.0-alt3
%define gtk_theme_prefix gtk2-theme
%define old_theme_prefix gtk2-themes
%define theme_namechange_ver 2.8.0-alt4

%def_disable lua
# Clearlooks animation takes some CPU cycles, so it's done optional.
%def_enable animation
%def_disable check

Name: %{engine_prefix}s-default
Version: %ver_major.2
Release: alt4
Epoch: 1

Summary: Default GTK+2 theme engines
License: LGPL-2.1-or-later
Group: Graphical desktop/GNOME
Url: http://gtk.themes.org/

Source: ftp://ftp.gnome.org/pub/gnome/sources/%_name/%ver_major/%_name-%version.tar.bz2
Patch: %_name-2.20.2-alt-glib_fixes.patch
Patch1: gtk-engines-2.20-lua-alt-lua5.3.patch

Obsoletes: %old_engine_prefix <= %engine_namechange_ver
Provides: %old_engine_prefix = %version-%release
Obsoletes: %old_engine_prefix-default <= %engine_namechange_ver
Provides: %old_engine_prefix-default = %version-%release
Obsoletes: %engine_prefix-default <= %engine_namechange_ver
Provides: %engine_prefix-default = %version-%release

%define gtk_ver 2.10.0
%define gtk_binary_ver 2.10.0
%define icon_theme_ver 2.10.0

Requires: %engine_prefix-redmond = %version-%release
Requires: %engine_prefix-hc = %version-%release
Requires: %engine_prefix-crux = %version-%release
Requires: %engine_prefix-mist = %version-%release
Requires: %engine_prefix-thinice = %version-%release
Requires: %engine_prefix-industrial = %version-%release
Requires: %engine_prefix-clearlooks = %version-%release
Requires: %engine_prefix-glide = %version-%release

BuildPreReq: rpm-build-gnome rpm-build-licenses

BuildPreReq: intltool >= 0.31.0
BuildPreReq: libgtk+2-devel >= %gtk_ver
BuildPreReq: lua-devel

%description
These are the graphical engines for the various GTK+2 toolkit themes.

# FIXME: Recollect/Find out and explain here why GTK+ engines need
# gnome-icon-theme. Looks rather suspicious.

%package -n %name-common
Summary: Files common to all GTK+ engines
Group: Graphical desktop/GNOME

%description -n %name-common
This package contains files used or referred to by any "standard" GTK+
engine. Don't care about installing it; you will know if some GTK+
engine needs it.

%package -n %engine_prefix-redmond
Summary: GTK+2 theme engine - Redmond95
Group: Graphical desktop/GNOME
License: LGPL-2.1-or-later
Requires: %name-common = %version-%release
Obsoletes: %old_engine_prefix-redmond95
Provides: %old_engine_prefix-redmond95 = %version-%release
Provides: %engine_prefix-redmond95 = %version-%release
Obsoletes: %old_engine_prefix-redmond < %engine_namechange_ver
Provides: %old_engine_prefix-redmond = %version-%release

%description -n %engine_prefix-redmond
A simple theme engine that looks a bit like another OS.

%package -n %gtk_theme_prefix-redmond
Summary: GTK+2 theme - Redmond95
Group: Graphical desktop/GNOME
License: LGPL-2.1-or-later
Obsoletes: %old_theme_prefix-redmond < %engine_namechange_ver
Provides: %old_theme_prefix-redmond = %version-%release
# Due to file conflicts
Obsoletes: %old_theme_prefix-redmond = %version-%release
Requires: gnome-icon-theme >= %icon_theme_ver

%description -n %gtk_theme_prefix-redmond
A simple theme that looks a bit like another OS.

%package -n %engine_prefix-hc
Summary: A GTK+2 high contrast theme engine
Group: Graphical desktop/GNOME
License: LGPL-2.1-or-later
Requires: %name-common = %version-%release
Obsoletes: %old_engine_prefix-hc < %engine_namechange_ver
Provides: %old_engine_prefix-hc = %version-%release
Requires: gnome-icon-theme >= %icon_theme_ver

%description -n %engine_prefix-hc
Engine for high contrast themes, that improves visibility of shadows, edges,
and indicators when theme background and foreground contain near-black
and near-white colors.

%package -n %gtk_theme_prefix-crux
Summary: A GTK+2 theme engine - Crux
Group: Graphical desktop/GNOME
License: LGPL-2.1-or-later
Requires: %name-common = %version-%release
Obsoletes: %old_engine_prefix-crux < 2.7.6
Provides: %old_engine_prefix-crux = %version-%release
Obsoletes: %old_theme_prefix-crux < %theme_namechange_ver
Provides: %old_theme_prefix-crux = %version-%release
Provides: %engine_prefix-crux = %version-%release
Requires: gnome-icon-theme >= %icon_theme_ver

%description -n %gtk_theme_prefix-crux
This package contains a GTK2+ theme engine named Crux and developed by
Eazel, Inc.

%package -n %gtk_theme_prefix-mist
Summary: A GTK+2 theme engine - Mist
Group: Graphical desktop/GNOME
License: LGPL-2.1-or-later
Requires: %name-common = %version-%release
Obsoletes: %old_engine_prefix-mist < 2.7.6
Provides: %old_engine_prefix-mist = %version-%release
Obsoletes: %old_theme_prefix-mist < %theme_namechange_ver
Provides: %old_theme_prefix-mist = %version-%release
Provides: %engine_prefix-mist = %version-%release
Requires: gnome-icon-theme >= %icon_theme_ver

%description -n %gtk_theme_prefix-mist
Author named this after the song he was listening to when he named it
(Opeth's "In Mist She Was Standing").
This package provides Mist GTK+2 theme engine.

%package -n %gtk_theme_prefix-clearlooks
Summary: A GTK+2 theme engine - ClearLooks
Group: Graphical desktop/GNOME
License: LGPL-2.1-or-later
Requires: %name-common = %version-%release
Obsoletes: %old_engine_prefix-clearlooks < 2.7.6
Provides: %old_engine_prefix-clearlooks = %version-%release
Obsoletes: %old_theme_prefix-clearlooks < %theme_namechange_ver
Provides: %old_theme_prefix-clearlooks = %version-%release
Provides: %engine_prefix-clearlooks = %version-%release
Requires: gnome-icon-theme >= %icon_theme_ver

%description -n %gtk_theme_prefix-clearlooks
ClearLooks is new modern looking engine for GTK+2, based on Bluecurve.
It has the looks of various themes blended together, resulting in a
theme that's easy on the eyes and visually pleasing.

This package contains Clearlooks theme and engine.

%package -n %gtk_theme_prefix-thinice
Summary: A GTK+2 theme engine - Thin Ice
Group: Graphical desktop/GNOME
License: LGPL-2.1-or-later
Requires: %name-common = %version-%release
Obsoletes: %engine_prefix-thinice-devel
Obsoletes: %old_engine_prefix-thinice < 2.7.6
Provides: %old_engine_prefix-thinice = %version-%release
Obsoletes: %old_theme_prefix-thinice < %theme_namechange_ver
Provides: %old_theme_prefix-thinice = %version-%release
Provides: %engine_prefix-thinice = %version-%release
Requires: gnome-icon-theme >= %icon_theme_ver

%description -n %gtk_theme_prefix-thinice
This package contains a GTK2+ theme engine Thin Ice.

%package -n %gtk_theme_prefix-industrial
Summary: A GTK+2 theme engine - Industrial
Group: Graphical desktop/GNOME
License: LGPL-2.1-or-later
Requires: %name-common = %version-%release
Obsoletes: %old_engine_prefix-industrial < 2.7.6
Provides: %old_engine_prefix-industrial = %version-%release
Obsoletes: %old_theme_prefix-industrial < %theme_namechange_ver
Provides: %old_theme_prefix-industrial = %version-%release
Provides: %engine_prefix-industrial = %version-%release
Requires: gnome-icon-theme >= %icon_theme_ver

%description -n %gtk_theme_prefix-industrial
This package contains a GTK2+ engine Industrial developed by Ximian, Inc. as
the default apearance for its Desktop. Industrial is a highly popular
look which provides a simple, consistant, and highly cohesive appearance
for applications.

%package -n %engine_prefix-glide
Summary: A GTK+2 theme engine - Glide
Group: Graphical desktop/GNOME
License: LGPL-2.1-or-later
Requires: %name-common = %version-%release
Obsoletes: %old_engine_prefix-glide < %engine_namechange_ver
Provides: %old_engine_prefix-glide = %version-%release
Requires: gnome-icon-theme >= %icon_theme_ver

%description -n %engine_prefix-glide
This package contains a GTK2+ theme engine Glide (used by Glider GNOME theme).

%package -n %engine_prefix-lua
Summary: A Lua scripting engine for GTK+ themes
Group: Graphical desktop/GNOME

%description -n %engine_prefix-lua
This package contains an engine that enables Lua scripting in GTK+ themes. Unless some GTK+ theme depends on this package, you don't need it.

%package -n %{engine_prefix}s-devel
Summary: Development files for %_name
Group: Development/GNOME and GTK+
Obsoletes: %old_engine_prefix-default-devel < %engine_namechange_ver
Provides: %old_engine_prefix-default-devel = %version-%release

%description -n %{engine_prefix}s-devel
This package contains development files for %_name

%prep
%setup -q -n %_name-%version
%patch -p1
%patch1 -p2

%build
%autoreconf
%configure \
    %{subst_enable lua} \
    %{subst_enable animation}
%nil
%make

%install
%makeinstall_std
%find_lang %_name

%define engines_dir %_libdir/gtk-2.0/%gtk_binary_ver/engines/
%define engines_data_dir %_datadir/%_name/

ln -s gtk-2.0/%gtk_binary_ver/engines/libclearlooks.so %buildroot%_libdir/libclearlooks.so

%check
%make -k check VERBOSE=1

%files

%files -n %name-common -f %_name.lang
%dir %_datadir/%_name
%doc AUTHORS README ChangeLog COPYING*

%files -n %engine_prefix-redmond
%engines_dir/libredmond95.so
%engines_data_dir/redmond95.xml

%files -n %gtk_theme_prefix-redmond
%dir %_datadir/themes/Redmond/
%dir %_datadir/themes/Redmond/gtk-2.0
%_datadir/themes/Redmond/gtk-2.0/gtkrc
#dir %_datadir/themes/Redmond/gtk
#_datadir/themes/Redmond/gtk/gtkrc
%doc engines/redmond/AUTHORS

%files -n %engine_prefix-hc
%engines_dir/libhcengine.so
%engines_data_dir/hcengine.xml

%files -n %gtk_theme_prefix-crux
%engines_dir/*crux*.so
%engines_data_dir/crux-engine.xml
%dir %_datadir/themes/Crux
%dir %_datadir/themes/Crux/gtk-2.0
%_datadir/themes/Crux/gtk-2.0/gtkrc

%files -n %gtk_theme_prefix-clearlooks
%engines_dir/*clearlooks.so
%engines_data_dir/clearlooks.xml
%_libdir/*clearlooks.so
%dir %_datadir/themes/Clearlooks
%dir %_datadir/themes/Clearlooks/gtk-2.0
%_datadir/themes/Clearlooks/gtk-2.0/gtkrc

%files -n %gtk_theme_prefix-mist
%engines_dir/libmist.so
%engines_data_dir/mist.xml
%dir %_datadir/themes/Mist
%dir %_datadir/themes/Mist/gtk-2.0
%_datadir/themes/Mist/gtk-2.0/gtkrc

%files -n %gtk_theme_prefix-thinice
%engines_dir/*thinice.so
%engines_data_dir/thinice.xml
%dir %_datadir/themes/ThinIce
%dir %_datadir/themes/ThinIce/gtk-2.0
%_datadir/themes/ThinIce/gtk-2.0/gtkrc

%files -n %gtk_theme_prefix-industrial
%engines_dir/libindustrial.so
%engines_data_dir/industrial.xml
%dir %_datadir/themes/Industrial
%dir %_datadir/themes/Industrial/gtk-2.0
%_datadir/themes/Industrial/gtk-2.0/gtkrc

%files -n %engine_prefix-glide
%engines_dir/libglide.so
%engines_data_dir/glide.xml

%if_enabled lua
%files -n %{engine_prefix}-lua
%engines_dir/libluaengine.so
%endif

%files -n %{engine_prefix}s-devel
%_pkgconfigdir/*.pc

%exclude %engines_dir/*.la

%changelog
