%def_disable snapshot

%define _name gspell
%define namespace Gspell
%define ver_major 1.14
%define api_ver 1
%define sover 3

%def_enable installed_tests
%def_enable gtk_doc
%def_enable check

Name: lib%_name
Version: %ver_major.2
Release: alt1

Summary: A spell-checking library for GTK+3 applications
Group: System/Libraries
License: LGPL-2.1-or-later
Url: https://wiki.gnome.org/Projects/gspell

Vcs: https://gitlab.gnome.org/GNOME/gspell.git

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%_name/%ver_major/%_name-%version.tar.xz
%else
Source: %_name-%version.tar
%endif

%define gtk_ver 3.20.0
%define enchant_ver 2.2.12

BuildRequires(pre): rpm-macros-meson rpm-build-gir rpm-build-vala %{?_enable_check:rpm-macros-valgrind}
BuildRequires: meson
BuildRequires: libgtk+3-devel >= %gtk_ver libenchant2-devel >= %enchant_ver libicu-devel
BuildRequires: gobject-introspection-devel libgtk+3-gir-devel vala-tools
%{?_enable_gtk_doc:BuildRequires: gtk-doc}
%if_enabled check
BuildRequires: xvfb-run hunspell-en
%ifarch %valgrind_arches
BuildRequires: valgrind
%endif
%endif

%description
gspell library provides a flexible API to add spell checking to a GTK+
applications.

%package devel
Summary: Development files for %name
Group: Development/C++
Requires: %name = %EVR
Requires: libenchant2-devel >= %enchant_ver

%description devel
Development files for %_name, spell-checking library for GTK+
applications.

%package gir
Summary: GObject introspection data for the Gspell
Group: System/Libraries
Requires: %name = %EVR

%description gir
GObject introspection data for the Gspell library.

%package gir-devel
Summary: GObject introspection devel data for the Gspell
Group: Development/Other
BuildArch: noarch
Requires: %name-gir = %EVR
Requires: %name-devel = %EVR

%description gir-devel
GObject introspection devel data for the Gspell library.

%package devel-doc
Summary: Development documentation for Gspell
Group: Development/Documentation
Conflicts: %name < %version-%release
BuildArch: noarch

%description devel-doc
This package contains development documentation for Gspell library.

%package tests
Summary: Tests for Gspell library
Group: Development/Other
Requires: %name = %EVR

%description tests
This package provides tests programs that can be used to verify
the functionality of the installed Gspell library.

%prep
%setup -n %_name-%version

%build
%meson \
    %{subst_enable_meson_bool gtk_doc gtk_doc} \
    %{subst_enable_meson_bool installed_tests install_tests}
%nil
%meson_build

%install
%meson_install
%find_lang --output=%name.lang %_name-%api_ver

%check
xvfb-run %__meson_test

%files -f %name.lang
%_bindir/%_name-app1
%_libdir/%name-%api_ver.so.%{sover}*
%doc AUTHORS NEWS README*

%files devel
%_includedir/%_name-%api_ver/
%_libdir/%name-%api_ver.so
%_pkgconfigdir/%_name-%api_ver.pc
%_vapidir/%_name-%api_ver.*

%files gir
%_typelibdir/%namespace-%api_ver.typelib

%files gir-devel
%_girdir/%namespace-%api_ver.gir

%files devel-doc
%_datadir/gtk-doc/html/%_name-*/

%if_enabled installed_tests
%files tests
%_libexecdir/installed-tests/%_name-%api_ver/
%_datadir/installed-tests/%_name-%api_ver/
%endif


%changelog
