%def_disable snapshot
%define _name graphite2
%def_disable docs
%def_enable check

Name: lib%_name
Version: 1.3.14
Release: alt2.1

Summary: Font rendering capabilities for complex non-Roman writing systems
Group: System/Libraries
License: LGPL-2.1-or-later or MPL-1.0
Url: http://sourceforge.net/projects/silgraphite/

%if_disabled snapshot
Source: http://downloads.sourceforge.net/silgraphite/%_name-%version.tgz
%else
# VCS: https://github.com/silnrsi/graphite.git
Source: %_name-%version.tar
%endif

Obsoletes: %_name
Provides: %_name = %version-%release

# fc patch
Patch1: graphite2-1.2.0-cmakepath.patch
# lcc/e2k fixup
Patch2: graphite2-1.3.13-alt-e2k-lcc123.patch
Patch3: graphite2-1.3.13-alt-e2k-linking.patch

BuildRequires: gcc-c++ cmake ctest libfreetype-devel
%ifarch %e2k
BuildRequires: libstdc++5-devel-static
%endif
%{?_enable_docs:BuildRequires: doxygen asciidoc-a2x dblatex %_bindir/pdflatex}
%{?_enable_check:BuildRequires: python3-module-fonttools}

%description
Graphite2 is a project within SIL's Non-Roman Script Initiative and
Language Software Development groups to provide rendering capabilities
for complex non-Roman writing systems. Graphite can be used to create
"smart fonts" capable of displaying writing systems with various
complex behaviors. With respect to the Text Encoding Model, Graphite
handles the "Rendering" aspect of writing system implementation.

%package devel
Summary: Files for developing with Graphite2
Group: Development/C++
Provides: %_name-devel = %version-%release
Requires: %name = %version-%release

%description devel
Includes and definitions for developing with Graphite2.

%prep
%setup -n %_name-%version
%patch1 -p1 -b .cmake
%patch2 -p1 -b .e2k-lcc123
%patch3 -p2 -b .e2k-linking

%build
%add_optflags %(getconf LFS_CFLAGS)
%cmake -DGRAPHITE2_COMPARE_RENDERER=OFF \
	-DCMAKE_SHARED_LINKER_FLAGS=$LIBS \
	-DPYTHON_EXECUTABLE:FILEPATH=%_bindir/python3 \
	-DCMAKE_VERBOSE_MAKEFILE:BOOL=ON
%cmake_build

%if_enabled docs
%cmake_build -t docs
sed -i -e 's!<a id="id[a-z]*[0-9]*"></a>!!g' BUILD/doc/manual.html
%endif

%install
%cmake_install

%check
LD_LIBRARY_PATH=%buildroot%_libdir %cmake_build -t test

%files
%_libdir/%name.so.*
%doc COPYING ChangeLog

%files devel
%_bindir/gr2fonttest
%_includedir/%_name/
%_libdir/%name.so
%dir %_libdir/%_name/
%_libdir/%_name/%_name-release.cmake
%_libdir/%_name/%_name.cmake
%_pkgconfigdir/%_name.pc
%{?_enable_docs:%doc BUILD/doc/manual.html}

%changelog
