%def_disable snapshot

%define _name goffice
%define ver_major 0.10
%define api_ver 0.10
%define namespace GOffice

%def_with lasem
%def_enable introspection
%ifarch %ix86 ppc64le
%def_disable check
%endif

%def_enable gtk_doc

Name: libgnomeoffice%api_ver
Version: %ver_major.59
Release: alt1

Summary: Library for writing gnome office programs
Group: Graphical desktop/GNOME
License: GPL-2.0 or GPL-3.0
Url: http://www.gnumeric.org/

Vcs: https://gitlab.gnome.org/GNOME/goffice.git

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%_name/%ver_major/%_name-%version.tar.xz
%else
Source: %_name-%version.tar
%endif

%define glib_ver 2.28.0
%define gsf_ver 1.14.47
%define gtk_ver 3.0.0
%define cairo_ver 1.10.0
%define lasem_ver 0.4.1

%{?_enable_introspection:BuildRequires(pre): rpm-build-gir}
BuildRequires: libgio-devel >= %glib_ver
BuildRequires: libgsf-devel >= %gsf_ver
BuildRequires: libgtk+3-devel >= %gtk_ver
BuildRequires: libcairo-devel >= %cairo_ver
BuildRequires: libgs-devel
BuildRequires: libXext-devel libXrender-devel libxml2-devel libxslt-devel librsvg-devel
BuildRequires: intltool gtk-doc
%{?_enable_introspection:BuildRequires: gobject-introspection-devel libgsf-gir-devel libgtk+3-gir-devel}
%{?_with_lasem:BuildRequires: liblasem-devel >= %lasem_ver}

%description
GOffice is a library that eases the task of writing gnome office
programs.

%package devel
Summary: Development libraries and header files for %name
Group: Development/C
Requires: %name = %EVR

%description devel
This package contains the header files and libraries needed to write and
compile programs that use %name.

%package devel-doc
Summary: Development documentation for Goffice
Group: Development/Documentation
Conflicts: %name < %version-%release
BuildArch: noarch

%description devel-doc
This package contains development documentation for Goffice library.

%package gir
Summary: GObject introspection data for the Goffice library
Group: System/Libraries
Requires: %name = %EVR

%description gir
GObject introspection data for the Goffice library.

%package gir-devel
Summary: GObject introspection devel data for the Goffice library
Group: Development/Other
BuildArch: noarch
Requires: %name-gir = %EVR
Requires: %name-devel = %EVR

%description gir-devel
GObject introspection devel data for the Goffice library.


%define _libexecdir %_libdir/%name

%prep
%setup -n %_name-%version

%build
%autoreconf
%configure \
    --with-config-backend=gsettings \
    %{subst_with lasem} \
    %{?_enable_introspection:--enable-introspection=yes} \
    %{?_enable_gtk_doc:--enable-gtk-doc}
%nil
%make_build

%install
%makeinstall_std

%find_lang --output=%_name.lang %_name-%version

%check
%make check

%files -f %_name.lang
%_libdir/*.so.*
%dir %_libdir/%_name
%dir %_libdir/%_name/%version
%dir %_libdir/%_name/%version/plugins
%_libdir/%_name/%version/plugins/plot_barcol/
%_libdir/%_name/%version/plugins/plot_distrib/
%_libdir/%_name/%version/plugins/plot_pie/
%_libdir/%_name/%version/plugins/plot_radar/
%_libdir/%_name/%version/plugins/plot_surface/
%_libdir/%_name/%version/plugins/plot_xy/
%_libdir/%_name/%version/plugins/reg_linear/
%_libdir/%_name/%version/plugins/reg_logfit/
%_libdir/%_name/%version/plugins/smoothing/
%_libdir/%_name/%version/plugins/lasem/
%dir %_datadir/%_name
%dir %_datadir/%_name/%version
%_datadir/%_name/%version/mmlitex/
%doc AUTHORS NEWS README

%exclude %_libdir/%_name/%version/plugins/*/*.la

%files devel
%_includedir/lib%_name-%api_ver/
%_libdir/*.so
%_pkgconfigdir/*

%if_enabled gtk_doc
%files devel-doc
%_datadir/gtk-doc/html/%_name-%api_ver/
%endif

%if_enabled introspection
%files gir
%_typelibdir/%namespace-%api_ver.typelib

%files gir-devel
%_girdir/%namespace-%api_ver.gir
%endif


%changelog
