%define _name libgnome-games-support

%define ver_major 2.0
%define beta %nil
%define api_ver 2

Name: %_name%api_ver
Version: %ver_major.2
Release: alt1%beta

Summary: Shared library for GNOME games
Group: System/Libraries
License: LGPL-3.0-or-later

Vcs: https://gitlab.gnome.org/GNOME/libgnome-games-support.git

Url: https://wiki.gnome.org/Apps/Games
Source: ftp://ftp.gnome.org/pub/gnome/sources/%_name/%ver_major/%_name-%version%beta.tar.xz

%define glib_ver 2.40
%define gtk_ver 4.2.0
%define gee_ver 0.14
%define vala_ver 0.39.6

BuildRequires(pre): rpm-macros-meson
BuildRequires: meson vala-tools >= %vala_ver libgio-devel >= %glib_ver
BuildRequires: libgtk4-devel >= %gtk_ver libgee0.8-devel >= %gee_ver

%description
%name provides code that's useful for different GNOME games.

%package devel
Summary: Development files for %name
Group: Development/C
Requires: %name = %EVR
Requires: libgee0.8-devel

%description devel
The %name-devel package contains libraries and header files for
developing applications that use %name.

%prep
%setup -n %_name-%version%beta

%build
%meson
%meson_build

%install
%meson_install

%find_lang %name

%files -f %name.lang
%_libdir/%_name-%api_ver.so.*
%doc README NEWS

%files devel
%_includedir/gnome-games-support-%api_ver/
%_libdir/%_name-%api_ver.so
%_pkgconfigdir/%_name-%api_ver.pc
%_vapidir/%_name-%api_ver.vapi

%changelog
