# vim: set ft=spec: -*- spec -*-

# Please, RPM, do not remove documentation after installing...
%define _customdocdir %_docdir/%name-%version

%define oname gle

Name: lib%oname
Version: 3.1.2
Release: alt1
Summary: The GLE Tubing and Extrusion Library for OpenGL
License: GPL-2.0
Group: System/Libraries
Url: http://www.linas.org/gle
Vcs: https://github.com/linas/glextrusion.git

Source: %name-%version.tar

BuildRequires: libXi-devel libXmu-devel libfreeglut-devel

%description
The GLE Tubing and Extrusion Library consists of a number of "C"
language subroutines for drawing tubing and extrusions. It is a very
fast implementation of these shapes, outperforming all other
implementations, most by orders of magnitude. It uses the
OpenGL (TM) programming API to perform the actual drawing of the tubing
and extrusions.

%package devel
Summary: Dedelopment headers for the GLE Tubing and Extrusion Library
Group: Development/C
Requires: %name = %version-%release
# Due to %_includedir/GL directory...
Requires: xorg-glproto-devel

%description devel
The GLE Tubing and Extrusion Library consists of a number of "C"
language subroutines for drawing tubing and extrusions. It is a very
fast implementation of these shapes, outperforming all other
implementations, most by orders of magnitude. It uses the
OpenGL (TM) programming API to perform the actual drawing of the tubing
and extrusions.

This package contain development headers and libraries.

%package doc
Summary: Documentation for the GLE Tubing and Extrusion Library
Group: Books/Computer books
Conflicts: %name > %version-%release
Conflicts: %name < %version-%release
Obsoletes: gle-doc <= 3.1.0-alt3
BuildArch: noarch

%description doc
The GLE Tubing and Extrusion Library consists of a number of "C"
language subroutines for drawing tubing and extrusions. It is a very
fast implementation of these shapes, outperforming all other
implementations, most by orders of magnitude. It uses the
OpenGL (TM) programming API to perform the actual drawing of the tubing
and extrusions.

This package contains documentation.

%prep
%setup -q -n %name-%version

%build
export lt_cv_prog_cc_static_works=no
%autoreconf
%configure \
	--disable-static
%make_build libgle_la_LIBADD="-lGL -lGLU"

%install
%makeinstall_std libgle_la_LIBADD="-lGL -lGLU"
mv %buildroot%_docdir/%oname %buildroot%_docdir/%name-%version

%files
%doc %dir %_docdir/%name-%version
%doc %_docdir/%name-%version/*
%exclude %_docdir/%name-%version/examples
%exclude %_docdir/%name-%version/html
%_libdir/lib%oname.so.*

%files devel
%_libdir/lib%oname.so
%_includedir/GL/*
%_man3dir/*

%files doc
%doc %dir %_docdir/%name-%version
%doc %_docdir/%name-%version/examples
%doc %_docdir/%name-%version/html

%changelog
