%def_disable snapshot

%define _libexecdir %prefix/libexec
%define ver_major 1.86
%define _name gjs
%define api_ver 1.0
%define mozjs_ver_major 140
%define mozjs_ver 140.1.0

%def_disable check
%def_enable installed_tests

Name: lib%_name
Version: %ver_major.0
Release: alt1

Summary: Javascript Bindings for GNOME
Group: System/Libraries
License: GPL-2.0-or-later and LGPL-2.0-or-later and MIT
Url: https://wiki.gnome.org/action/show/Projects/Gjs

Vcs: https://gitlab.gnome.org/GNOME/gjs.git

%if_enabled snapshot
Source: %_name-%version.tar
%else
Source: ftp://ftp.gnome.org/pub/gnome/sources/%_name/%ver_major/%_name-%version.tar.xz
%endif

%define glib_ver 2.85.1
%define gir_api_ver 1.0
%define gir_ver 1.72

Requires: gobject-introspection
Requires: libmozjs%mozjs_ver_major >= %mozjs_ver

BuildRequires(pre): rpm-macros-meson rpm-build-gir rpm-macros-valgrind
BuildRequires: meson gcc-c++ libffi-devel libcairo-devel
BuildRequires: libmozjs%mozjs_ver_major-devel >= %mozjs_ver
BuildRequires: libgio-devel >= %glib_ver pkgconfig(gobject-introspection-%gir_api_ver) >= %gir_ver
BuildRequires: libreadline-devel libcairo-gobject-devel
BuildRequires: libgtk4-devel libgtk4-gir-devel
BuildRequires: pkgconfig(sysprof-capture-4)
%ifarch %valgrind_arches
BuildRequires: valgrind
%endif

%{?_enable_check:BuildRequires: /proc xvfb-run dbus-tools dbus-tools-gui
BuildRequires: typelib(Clutter) typelib(Gtk) = 3.0 typelib(Gtk) = 4.0}

%description
Gjs allows using GNOME libraries from Javascript. It's based on the
Spidermonkey Javascript engine from Mozilla and the GObject introspection
framework.

%package devel
Summary: Development package for %name
Group: Development/C++
Requires: %name = %EVR
Requires: /proc

%description devel
Files for development with %name.

%package tests
Summary: Tests for the Gjs package
Group: Development/Other
Requires: %name = %EVR
%add_typelib_req_skiplist typelib(versions)

%description tests
This package provides tests programs that can be used to verify
the functionality of the installed Gjs library package.

%set_typelibdir %_libdir/%_name/girepository-1.0

%prep
%setup -n %_name-%version

%build
%meson \
    %{?_disable_installed_tests:-Dinstalled-tests=false}
%meson_build

%install
%meson_install

%check
xvfb-run %__meson_test

%files
%_bindir/%_name
%_bindir/%_name-console
%_libdir/%name.so.*
%dir %_libdir/%_name/
%dir %_typelibdir
%_typelibdir/GjsPrivate-%api_ver.typelib
%dir %_datadir/%_name-%api_ver
%doc COPYING NEWS README*

%files devel
%_includedir/%_name-%api_ver/
%_libdir/%name.so
%_pkgconfigdir/%_name-%api_ver.pc
%_datadir/%_name-%api_ver/lsan/
%_datadir/%_name-%api_ver/valgrind/
%doc examples/*

%if_enabled installed_tests
%add_typelib_req_skiplist typelib(GIMarshallingTests) typelib(Regress) typelib(WarnLib) typelib(GjsTestTools)

%files tests
%_libexecdir/installed-tests/%_name
%_datadir/installed-tests/%_name/
%_datadir/glib-2.0/schemas/org.gnome.GjsTest.gschema.xml
%endif


%changelog
