%define _name gexiv2
%define ver_major 0.16
%define api_ver 0.16
%define namespace GExiv2

%def_enable gtk_doc
%def_enable vala
# conflicts with 0.10
%def_disable python3
%def_enable check

Name: lib%_name-%api_ver
Version: %ver_major.0
Release: alt1

Summary: GObject-based Exiv2 wrapper
Group: System/Libraries
License: GPL-2.0-or-later
Url: https://wiki.gnome.org/Projects/gexiv2

Vcs: https://gitlab.gnome.org/GNOME/gexiv2.git

Source: ftp://ftp.gnome.org/pub/gnome/sources/%_name/%ver_major/%_name-%version.tar.xz

%define exiv2_ver 0.28

BuildRequires(pre): rpm-macros-meson rpm-build-gir %{?_enable_python3:rpm-build-python3}
BuildRequires: meson gcc-c++
BuildRequires:libexiv2-devel >= %exiv2_ver
BuildRequires: libgio-devel gobject-introspection-devel
%{?_enable_python3:BuildRequires: python3-module-pygobject3-devel}
%{?_enable_gtk_doc:BuildRequires: gi-docgen}
%{?_enable_vala:BuildRequires: vala-tools}

%description
gexiv2 is a GObject-based wrapper around the Exiv2 library. It makes the
basic features of Exiv2 available to GNOME applications.

%package devel
Group: Development/C
Requires: %name = %EVR
Summary: GObject-based Exiv2 wrapper - development files

%description devel
gexiv2 is a GObject-based wrapper around the Exiv2 library. It makes the
basic features of Exiv2 available to GNOME applications.

This package provides headers and libraries needed to develop
applications using gexiv2 library.

%package devel-doc
Summary: Development documentation for gexiv2
Group: Development/Documentation
Conflicts: %name < %version-%release
BuildArch: noarch

%description devel-doc
gexiv2 is a GObject-based wrapper around the Exiv2 library. It makes the
basic features of Exiv2 available to GNOME applications.

This package contains development documentation for gexiv2 library.

%package gir
Summary: GObject introspection data for the gexiv2 library
Group: System/Libraries
Requires: %name = %EVR

%description gir
GObject introspection data for the gexiv2 library.

%package gir-devel
Summary: GObject introspection devel data for the gexiv2 library
Group: Development/Other
BuildArch: noarch
Requires: %name-gir = %EVR

%description gir-devel
GObject introspection devel data for the gexiv2 library.

%package -n python3-module-%_name
Summary: Python3 bindings for Gexiv2
Group: Development/Python3
BuildArch: noarch

%description -n python3-module-%_name
This package provides Python3 bindings for the gexiv2 library.

%prep
%setup -n %_name-%version

%build

%meson \
    -Dintrospection=true \
    %{subst_enable_meson_bool vala vapi} \
    %{subst_enable_meson_bool gtk_doc gtk_doc} \
    %{subst_enable_meson_bool python3 python3}
%nil
%meson_build

%install
%meson_install

%check
%__meson_test

%files
%_libdir/lib%_name-%api_ver.so.*
%doc AUTHORS README* THANKS NEWS

%files devel
%_includedir/%_name-%api_ver/
%_libdir/lib%_name-%api_ver.so
%_pkgconfigdir/%_name-%api_ver.pc
%{?_enable_vala:%_vapidir/%_name-%api_ver.*}

%files gir
%_typelibdir/%namespace-%api_ver.typelib

%files gir-devel
%_girdir/%namespace-%api_ver.gir

%{?_enable_python3:
%files -n python3-module-%_name
%python3_sitelibdir_noarch/gi/overrides/GExiv2.py*
%python3_sitelibdir_noarch/gi/overrides/__pycache__/GExiv2.cpython-*.pyc}

%if_enabled gtk_doc
%files devel-doc
%_datadir/doc/%_name-%api_ver/
%endif

%changelog
