%define soname 2
Name: libdvdcss
Version: 1.5.0
Release: alt1
Summary: A portable abstraction library for DVD decryption
License: GPLv2
Group: System/Libraries
Url: https://www.videolan.org/developers/libdvdcss.html
VCS: https://code.videolan.org/videolan/libdvdcss.git


Source: %name-%version.tar
Patch: %name-%version-%release.patch

BuildRequires: doxygen
BuildRequires: rpm-macros-meson
BuildRequires: meson

%description
This is a portable abstraction library for DVD decryption.

libdvdcss is part of the VideoLAN project, a full MPEG2 client/server
solution. The VideoLAN Client can also be used as a standalone program
to play MPEG2 streams from a hard disk or a DVD.

%package devel
Summary: Development environment for %name
Group: Development/C
Requires: libdvdcss = %EVR

%description devel
This package contains development files required for building
%name-based software.

%prep
%setup -q
%patch -p1

%build
%meson -Ddefault_library=shared -Denable_docs=true
%meson_build

%install
%meson_install

%files
%doc AUTHORS NEWS README.md
%_libdir/libdvdcss.so.%soname
%_libdir/libdvdcss.so.%soname.*

%files devel
%doc %__builddir/doc/html
%_includedir/*
%_libdir/libdvdcss.so
%_pkgconfigdir/*.pc

%changelog
