%define _unpackaged_files_terminate_build 1

# Tests failed on x86
%ifarch %ix86
%def_without check
%else
%def_with check
%endif

%define soname 0

Name: libdqlite
Version: 1.18.2
Release: alt1
Summary: Library for distributed SQLite database
License: Apache-2.0
Group: Development/Databases
URL: https://github.com/CanonicalLtd/dqlite
VCS: https://github.com/CanonicalLtd/dqlite

Source: %name-%version.tar

BuildRequires: libuv-devel
BuildRequires: libsqlite3-devel
BuildRequires: liblz4-devel

%description
This package provides the `dqlite` C library (libdqlite), which can be used
to expose a SQLite database over the network and replicate it across a cluster
of peers, using the Raft algorithm.

%package -n libdqlite%soname
Summary: Library for distributed SQLite database
Group: Development/Databases
Obsoletes: libdqlite < 1.18.0

%description -n libdqlite%soname
This package provides the `dqlite` C library (libdqlite), which can be used
to expose a SQLite database over the network and replicate it across a cluster
of peers, using the Raft algorithm.

%package devel
Summary: Library for distributed SQLite database (development files)
Group: Development/Databases
Requires: libdqlite%soname = %EVR

%description devel
This package provides the `dqlite` C library (libdqlite), which can be used
to expose a SQLite database over the network and replicate it across a cluster
of peers, using the Raft algorithm.

%prep
%setup

%build
%autoreconf
%configure --enable-build-raft --enable-replication --disable-static

%make_build all

%check
# Test failed in hasher
sed -i '/raft-uv-integration-test$(EXEEXT) \\/d' Makefile
sed -i '/ raft-uv-unit-test$(EXEEXT)/d' Makefile
%make_build check

%install
%make_install install DESTDIR=%buildroot

%files -n libdqlite%soname
%doc AUTHORS README.md LICENSE
%_libdir/libdqlite.so.%{soname}*

%files devel
%_includedir/dqlite.h
%_libdir/libdqlite.so
%_pkgconfigdir/dqlite.pc

%changelog
