%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

%def_disable docs
%define develname libdbi-devel

Name: libdbi
Epoch: 1
Version: 0.9.0
Release: alt3
Summary: Database Independent Abstraction Layer for C
License: LGPL
Group: System/Libraries
Url: http://libdbi.sourceforge.net/

Source: %name-%version.tar

# Automatically added by buildreq on Mon Feb 09 2009
BuildRequires: gcc-c++

%if_enabled docs
BuildRequires: docbook-style-dsssl openjade w3c-markup-validator-libs
%endif

%description
libdbi implements a database-independent abstraction layer in C, similar to the
DBI/DBD layer in Perl. Writing one generic set of code, programmers can
leverage the power of multiple databases and multiple simultaneous database
connections by using this framework.

%package -n %develname
Summary: Library and header files for the %name library
Group: Development/C
Requires: %name = %EVR

%description -n %develname
libdbi implements a database-independent abstraction layer in C, similar to the
DBI/DBD layer in Perl. Writing one generic set of code, programmers can
leverage the power of multiple databases and multiple simultaneous database
connections by using this framework.

This package contains the header files.

%prep
%setup
%if_enabled docs
touch doc/libdbi-versioning.sgml
%endif
sed -i 's,-O20,%optflags_optimization,g' configure*

%build
%add_optflags -D_FILE_OFFSET_BITS=64

%autoreconf
%configure \
	%{subst_enable docs} \
	--disable-static \
	%nil

%make_build

%install
%makeinstall_std

%files
%doc AUTHORS ChangeLog INSTALL README
%_libdir/*.so.*

%files -n %develname
%doc README TODO
%if_enabled docs
%doc doc/programmers-guide doc/driver-guide doc/*.pdf
%endif
%_includedir/dbi
%_libdir/*.so
%_pkgconfigdir/dbi.pc

%changelog
