%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%define soversion 15
%set_verify_elf_method strict

%{?optflags_lto:%global optflags_lto %optflags_lto -ffat-lto-objects}

%def_enable static

Name: libconfig
Version: 1.8.1
Release: alt1
Summary: C/C++ Configuration File Library
License: LGPLv2.1+
Group: System/Libraries
Url: https://hyperrealm.github.io/libconfig
VCS: https://github.com/hyperrealm/libconfig.git

Source: %name-%version.tar

# Automatically added by buildreq on Sat Oct 08 2011
# optimized out: libstdc++-devel
BuildRequires: flex gcc-c++
# explicitly added texinfo for info files
BuildRequires: texinfo

%description
Libconfig is a simple library for manipulating structured configuration
files, like this one: test.cfg. This file format is more compact and
more readable than XML. And unlike XML, it is type-aware, so it is not
necessary to do string parsing in application code.

Libconfig is very compact thus well-suited for memory constrained
systems like handheld devices.

The library includes bindings for both the C and C++ languages. It works
on POSIX-compliant UNIX systems (GNU/Linux, Mac OS X, Solaris, FreeBSD)
and Windows (2000, XP and later).

%package -n libconfig%soversion
Summary: C Configuration File Library
Group: System/Libraries

%description -n libconfig%soversion
libconfig is the C binding for libconfig library.

%package -n libconfig-devel
Summary: Header files for %name
Group: Development/Other
Requires: libconfig%soversion = %EVR

%description -n libconfig-devel
Header files for %name library.

%package -n libconfig-c++%soversion
Summary: C++ Configuration File Library
Group: System/Libraries
# doesn't require base, common code included in library

%description -n libconfig-c++%soversion
libconfig++ is the C++ binding for libconfig library.

%package -n libconfig-c++-devel
Summary: Header files for libconfig++ library
Group: Development/Other
Requires: libconfig-c++%soversion = %EVR
Requires: %name-devel = %EVR
Requires: libstdc++-devel

%description -n libconfig-c++-devel
Header files for libconfig++ library.

%if_enabled static
%package -n libconfig-devel-static
Summary: Static library files for %name
Group: Development/Other
Requires: %name-devel = %EVR
Requires: glibc-devel-static

%description -n libconfig-devel-static
Static library files for %name.

%package -n libconfig-c++-devel-static
Summary: Static library files for libconfig++
Group: Development/Other
Requires: %name-c++-devel = %EVR
Requires: libstdc++-devel-static

%description -n libconfig-c++-devel-static
Static library files for libconfig++.
%endif

%prep
%setup
rm -rf examples/Makefile*
rm -rf examples/*/Makefile*
rm -rf examples/*/*.vcproj
sed -i '/examples.*Makefile/d' configure.ac

%build
%add_optflags -D_FILE_OFFSET_BITS=64

%autoreconf
%configure \
	%{subst_enable static} \
	--disable-examples
%make_build

%install
%makeinstall_std

%files -n libconfig%soversion
%doc AUTHORS ChangeLog README NEWS TODO
%_libdir/libconfig.so.%soversion
%_libdir/libconfig.so.%soversion.*

%files -n libconfig-devel
%doc examples/
%_libdir/libconfig.so
%_includedir/libconfig.h
%_pkgconfigdir/libconfig.pc
%_infodir/libconfig.info*
%_libdir/cmake/libconfig++/libconfig++Config.cmake
%_libdir/cmake/libconfig/libconfigConfig.cmake

%files -n libconfig-c++%soversion
%_libdir/libconfig++.so.%soversion
%_libdir/libconfig++.so.%soversion.*

%files -n libconfig-c++-devel
%_libdir/libconfig++.so
%_includedir/libconfig.h++
%_pkgconfigdir/libconfig++.pc

%if_enabled static
%files -n libconfig-devel-static
%_libdir/libconfig.a

%files -n libconfig-c++-devel-static
%_libdir/libconfig++.a
%endif

%changelog
