%define shortname comps
%define major 0
%define libname lib%shortname%major
%define libname_devel lib%shortname-devel

%def_enable docs

Name: libcomps
Version: 0.1.23
Release: alt1

Summary: Comps XML file manipulation library

Group: System/Libraries
License: GPLv2+
Url: https://github.com/rpm-software-management/libcomps
Vcs: https://github.com/rpm-software-management/libcomps

Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3 rpm-macros-cmake
BuildRequires: /usr/bin/dot gcc-c++ pkgconfig(liblzma) python3(setuptools)
BuildRequires: pkgconfig(zlib)
BuildRequires: pkgconfig(libxml-2.0)
BuildRequires: pkgconfig(check)
BuildRequires: pkgconfig(expat)
BuildRequires: ccmake cmake ctest

%description
Libcomps is library for structure-like manipulation with content of
comps XML files. Supports read/write XML file, structure(s) modification.

%package -n %libname
Summary: Libraries for %name
Group: System/Libraries
#https://bugzilla.altlinux.org/show_bug.cgi?id=51577#c2
Provides: libcomps = %EVR
Obsoletes: libcomps < %EVR

%description -n %libname
Libraries for %name.

%package -n %libname_devel
Summary: Development files for libcomps library
Group: Development/C
Provides: %name-devel = %version-%release
Requires: %libname = %version-%release

%description -n %libname_devel
Development files for %name.

%if_enabled docs
%package doc
Summary: Documentation files for libcomps library
Group: Development/C
BuildArch: noarch
BuildRequires: doxygen

%description doc
Documentation files for libcomps library.

%package -n python-module-libcomps-doc
Summary: Documentation files for python bindings libcomps library
Group: Development/Python
Requires: python3-module-libcomps = %version-%release
BuildArch: noarch
BuildRequires: python3-module-sphinx python3-module-sphinx-sphinx-build-symlink
BuildRequires: python3-module-sphinx_rtd_theme

%description -n python-module-libcomps-doc
Documentation files for python bindings libcomps library.
%endif

%package -n python3-module-libcomps
Summary: Python 3 bindings for libcomps library
%{?python_provide:%python_provide python3-libcomps}
Group: Development/Python
BuildRequires: python3-devel
Requires: %libname = %version-%release

%description -n python3-module-libcomps
Python3 bindings for libcomps library.

%prep
%setup

# Fix build with sphinx 1.8.3
sed -i -e 's,sphinx.ext.pngmath,sphinx.ext.imgmath,' libcomps/src/python/docs/doc-sources/conf.py.in

%build
%cmake %{?_enable_%{docs}:-DSPHINX_EXECUTABLE="%_bindir/sphinx-build-3"} ./libcomps/
%cmake_build

%if_enabled docs
make docs -C %_arch-alt-linux
sphinx-build-3  %name/src/python/docs/doc-sources html
%endif

%check
%ctest

%install
%cmake_install

%files -n %libname
%doc README.md
%doc --no-dereference COPYING
%_libdir/libcomps.so.%major

%files -n %libname_devel
%_includedir/*
%_libdir/libcomps.so
%_libdir/pkgconfig/%name.pc

%if_enabled docs
%files doc
%doc %_arch-alt-linux/docs/libcomps-doc/html

%files -n python-module-libcomps-doc
%doc  html
%endif

%files -n python3-module-libcomps
%python3_sitelibdir/%name/

%changelog
