#
# spec file for package libcerror
#
# Copyright (c) 2013 SUSE LINUX Products GmbH, Nuernberg, Germany.
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

%set_autoconf_version 2.71

Name: libcerror
Version: 20240413
Release: alt2

Summary: Library for cross-platform C error functions
License: LGPLv3+
Group: Development/C

#DL-URL: https://github.com/libyal/libcerror/releases/download/20240413/libcerror-beta-20240413.tar.gz
Url: https://github.com/libyal/libcerror
Source: %name-alpha-%version.tar.gz

BuildRequires: pkg-config

%description
A library for cross-platform C error functions.

This package is part of the libyal library collection
and is used by other libraries in the collection.

%package devel
Summary: Development files for libcerror, a cross-platform C error library
Group: Development/C
Requires: %name = %version

%description devel
A library for cross-platform C error functions.

This subpackage contains libraries and header files for developing
applications that want to make use of libcerror.

%prep
%setup

%build
./autogen.sh
%configure \
	--disable-static \
	--enable-wide-character-type
%make_build

%install
%makeinstall_std

%check
./runtests.sh

%files
%_libdir/%name.so.*

%files devel
%doc AUTHORS ChangeLog COPYING* NEWS README
%_includedir/%name.h
%_includedir/%name
%_libdir/%name.so
%_pkgconfigdir/%name.pc
%_man3dir/%name.3.*

%changelog
