Name: libcec
Version: 7.1.1
Release: alt1

Summary: CEC support shared library
License: GPLv2
Group: System/Libraries
Url: http://libcec.pulse-eight.com/

Source0: %name-%version-%release.tar

BuildRequires: cmake gcc-c++ libcec-platform-devel liblockdev-devel libudev-devel
BuildRequires: python3-dev rpm-build-python3 swig

%package devel
Summary: CEC support development library
Group: Development/C
Requires: %name = %version-%release

%package utils
Summary: CEC utilities
Group: System/Kernel and hardware
Requires: %name = %version-%release

%package -n python3-module-cec
Summary: libcec python module
Group: Development/Python
Requires: %name = %version-%release

%description
libcec provides support for Pulse-Eight's USB-CEC adapter
and other CEC capable hardware.

%description devel
libcec provides support for Pulse-Eight's USB-CEC adapter
and other CEC capable hardware.
This package contains development files of libcec.

%description utils
libcec provides support for Pulse-Eight's USB-CEC adapter
and other CEC capable hardware.
This package contains commandline utilities of libcec.

%description -n python3-module-cec
libcec provides support for Pulse-Eight's USB-CEC adapter
and other CEC capable hardware.
This package contains Python bindings for libcec.

%prep
%setup
sed -ri '/DESTINATION/ s,lib/python,%_lib/python,' src/libcec/cmake/CheckPlatformSupport.cmake
sed -ri '/set_target_properties.+\sPROPERTIES\sVERSION/d' src/cec*-client/CMakeLists.txt

%build
%cmake -DHAVE_LINUX_API=1
%cmake_build

%install
%cmakeinstall_std

%files
%_libdir/lib*.so.*

%files devel
%_libdir/lib*.so
%_includedir/libcec
%_pkgconfigdir/libcec.pc

%files utils
%_bindir/cec-client
%_bindir/cecc-client

%files -n python3-module-cec
%_bindir/pyCecClient
%python3_sitelibdir/*/cec.*
%python3_sitelibdir/_pycec.so
%python3_sitelibdir/cec.py

%changelog
