%define oversion 39_1
Name: libcdf
Version: 3.9.1
Release: alt1

Summary: Common Data Format (CDF)

License: BSD-like
Group: System/Libraries
Url: http://cdf.gsfc.nasa.gov

Packager: Vitaly Lipatov <lav@altlinux.ru>

# Source-url: https://spdf.gsfc.nasa.gov/pub/software/cdf/dist/latest/linux/cdf%oversion-dist-all.tar.gz
Source: %name-%version.tar
Source1: http://cdf.gsfc.nasa.gov/html/FAQ.html

Patch1: %name-autotools.patch

BuildRequires: libncursesw-devel zlib-devel

%package devel
Summary: Development tools for the CDF library
Group: Development/C
Requires: %name = %version-%release

%package devel-static
Summary: Development tools for the CDF library
Group: Development/C
Requires: %name-devel = %version-%release

%description
CDF is the Common Data Format.  It is a conceptual data abstraction for
storing, manipulating, and accessing multidimensional data sets.  The basic
component of CDF is a software programming interface that is a device-
independent view of the CDF data model.  The application developer is
insulated from the actual physical file format for reasons of conceptual
simplicity, device independence, and future expandability.  CDF files
created on any given platform can be transported to any other platform onto
which CDF is ported and used with any CDF tools or layered applications.

The CDF software, documentation, and user support services are provided
by NASA and available to the public free of charge. There are no license
agreements or costs involved in obtaining or using CDF.

%description devel
The static libraries, header files and documentation for using the
CDF library in applications.

If you want to develop applications which will use the CDF library,
you'll need to install the %name-devel package.  You'll also need to
install the %name package.

%description devel-static
This package contains static libraries for developing with CDF library.

%prep
%setup
%patch1 -p2
cp %SOURCE1 FAQ.html
cp CDF_copyright.txt COPYING
cp CHANGES.txt ChangeLog
touch NEWS README AUTHORS
rm -rv cdfjava/lib
rm -rv src/lib/zlib

%build
%ifarch %e2k armh aarch64 loongarch64
%add_optflags -DIBMPC
%endif

%autoreconf
%configure --disable-static
%make_build

%install
%makeinstall_std

# There is a file in the package with a name starting with <tt>._</tt>, 
# the file name pattern used by Mac OS X to store resource forks in non-native 
# file systems. Such files are generally useless in packages and were usually 
# accidentally included by copying complete directories from the source tarball.
find $RPM_BUILD_ROOT -name '._*' -size 1 -print0 | xargs -0 grep -lZ 'Mac OS X' -- | xargs -0 rm -f
# for ones installed as %%doc
find . -name '._*' -size 1 -print0 | xargs -0 grep -lZ 'Mac OS X' -- | xargs -0 rm -f


%files
%_bindir/*
%_datadir/cdf/
%_libdir/*.so.*
%doc CHANGES.txt Release.notes FAQ.html README.* CDF_copyright.txt Help.*

%files devel
%_includedir/cdf.h
%_libdir/*.so
%doc samples cdfjava

%if_enabled static
%files devel-static
%_libdir/*.a
%endif

%changelog
