%def_disable   static
%def_disable   doc
%def_enable    ruby
%def_enable    python

Name:          libcaca
Version:       0.99.20.3
Release:       alt0.1
Summary:       Text mode graphics library
Group:         System/Libraries
License:       WTFPL
Url:           http://caca.zoy.org/wiki/libcaca
Vcs:           https://github.com/cacalabs/libcaca.git

Source:        %name-%version.tar
BuildRequires: gcc-c++
BuildRequires: imlib2-devel
BuildRequires: libncurses-devel
BuildRequires: libslang2-devel
BuildRequires: zlib-devel
%if_enabled doc
BuildRequires: doxygen
BuildRequires: texmf-latex-tabu
BuildRequires: tex-common texlive-base texlive-base-bin texlive-common
BuildRequires: texlive-fonts-recommended texlive-generic-recommended
BuildRequires: texlive-latex-base texlive-latex-recommended
BuildRequires: texlive-publishers texlive-xetex texmf-latex-xcolor
%endif

%{?optflags_lto:%global optflags_lto %optflags_lto -ffat-lto-objects}

%description
libcaca is the Colour AsCii Art library. It provides high level functions
for colour text drawing, simple primitives for line, polygon and ellipse
drawing, as well as powerful image to text conversion routines.

%package       devel
Summary:       Development files for libcaca
Group:         Development/C
Requires:      %name = %version-%release

%description   devel
libcaca is the Colour AsCii Art library. It provides high level functions
for colour text drawing, simple primitives for line, polygon and ellipse
drawing, as well as powerful image to text conversion routines.

This package contains the header files and static libraries needed to
compile applications or shared objects that use libcaca.

%package       -n caca-utils
Summary:       Text mode graphics utilities
Group:         Graphics
Requires:      %name = %version-%release

%description   -n caca-utils
This package contains utilities and demonstration programs for libcaca, the
Colour AsCii Art library.

cacaview is a simple image viewer for the terminal. It opens most image
formats such as JPEG, PNG, GIF etc. and renders them on the terminal using
ASCII art. The user can zoom and scroll the image, set the dithering method
or enable anti-aliasing.

cacaball is a tiny graphic program that renders animated ASCII metaballs on
the screen, cacafire is a port of AALib's aafire and displays burning ASCII
art flames, cacamoir animates colourful moire circles and cacaplas displays
an old school plasma effect.

cacademo is a simple application that shows the libcaca rendering features
such as line and ellipses drawing, triangle filling and sprite blitting.

%if_enabled    ruby
%package       -n ruby-caca
Summary:       Ruby bindings for libcaca
Group:         Graphics
Requires:      %name = %version-%release
Provides:      ruby-libcaca = %EVR, ruby-module-libcaca = %EVR
Obsoletes:     ruby-module-libcaca < %EVR, ruby-libcaca < %EVR
BuildRequires: rpm-build-ruby

%description   -n ruby-caca
libcaca is the Colour AsCii Art library. It provides high level functions
for colour text drawing, simple primitives for line, polygon and ellipse
drawing, as well as powerful image to text conversion routines.

This package contains Ruby bindings for libcaca.
%endif

%if_enabled    python
%package       -n python3-module-caca
Summary:       Python3 module bindings for libcaca
Group:         Other
BuildArch:     noarch
Requires:      %name = %version-%release
BuildRequires: python3-devel

%description   -n python3-module-caca
libcaca is the Colour AsCii Art library. It provides high level functions
for colour text drawing, simple primitives for line, polygon and ellipse
drawing, as well as powerful image to text conversion routines.

This package contains python3 module bindings for libcaca.
%endif

%prep
%setup
# fix python shebangs
find . -type f -print0 |
	xargs -r0 grep -lZ '^#![[:space:]]*%_bindir/.*python\>' -- |
	xargs -r0 sed -E -i '1 s@^(#![[:space:]]*)%_bindir/(env[[:space:]]+)?python\>@\1%__python3@' --

%build
# -ffat-lto-objects is needed even if static libraries are disabled
touch ChangeLog
%autoreconf
export PYTHON=%__python3
%configure \
	--enable-slang \
	--enable-ncurses \
	--enable-x11 \
	--enable-imlib2 \
	--x-libraries=%_x11libdir \
	--disable-debug \
	%{subst_enable python} \
	%{subst_enable ruby} \
	%{subst_enable doc} \
	%{subst_enable static}

%make_build V=1

%install
%makeinstall_std
rm %buildroot%_libdir/*.la
%if_enabled doc
rm -r %buildroot%_man3dir
rm -f %buildroot%_docdir/libcucul-dev
mv %buildroot%_datadir/doc/%name-dev %buildroot%_docdir/%name-%version
%endif

%files
%_libdir/*.so.*

%files devel
%_libdir/*.so
%_bindir/caca-config
%_man1dir/caca-config.1*
%_includedir/*
%_pkgconfigdir/*
%if_enabled doc
%_docdir/%name-%version
%endif

%files -n caca-utils
%_bindir/cacademo
%_bindir/cacafire
%_bindir/cacaclock
%_bindir/cacaplay
%_bindir/cacaserver
%_bindir/cacaview
%_bindir/img2txt
%_datadir/%name
%_man1dir/cacademo.1*
%_man1dir/cacafire.1*
%_man1dir/cacaplay.1*
%_man1dir/cacaserver.1*
%_man1dir/cacaview.1*
%_man1dir/img2txt.1*

%if_enabled    ruby
%files         -n ruby-caca
%ruby_vendorlibdir/caca.rb
%ruby_vendorarchdir/caca.*
%endif

%if_enabled    python
%files         -n python3-module-caca
%doc README
%python3_sitelibdir_noarch/*
%endif

%changelog
