%def_disable snapshot
%define api_version 1.6
%define rname atkmm
%define major 2.28

%def_enable docs
%def_enable check

Name: libatkmm
Version: %major.4
Release: alt1

Summary: A C++ interface for ATK library
License: LGPL-2.1-or-later
Group: System/Libraries
Url: http://atkmm.sourceforge.net/

%if_enabled snapshot
Source: %rname-%version.tar
%else
Source: ftp://ftp.gnome.org/pub/gnome/sources/%rname/%major/%rname-%version.tar.xz
%endif

Provides: %rname = %version

%define glibmm_ver 2.46.2
%define atk_ver 2.12

BuildRequires(pre): rpm-macros-meson
BuildRequires: meson gcc-c++ mm-common
BuildRequires:  libatk-devel >= %atk_ver libglibmm-devel >= %glibmm_ver
%{?_enable_docs:BuildRequires: docbook-style-xsl doxygen graphviz xsltproc}

%description
ATK, the Accessibility Tookit, is used to obtain accessibily information
from GTK+ and GNOME widgets.

ATKmm provides a C++ interface to the ATK library.

%package devel
Summary: Headers for developing programs that will use %name
Group: Development/C++
Requires: %name = %version-%release
Provides: %rname-devel = %version

%description devel
This package contains the static libraries and header files needed for
developing atkmm applications.

%package doc
Summary: Documentation for developing with %name
Group: Development/C++
BuildArch: noarch
Conflicts: %name-devel < %version

%description doc
This package contains the documentation for
developing atkmm applications.


%prep
%setup -n %rname-%version

%build
%{?_enable_snapshot:mm-common-prepare -f}
%meson \
    %{?_enable_docs:-Dbuild-documentation=true} \
    %{?_enable_snapshot:-Dmaintainer-mode=true
    -Dbuild-documentation=true}
%nil
%meson_build

%install
%meson_install

%check
%__meson_test

%files
%doc README* NEWS
%_libdir/*.so.*

%files devel
%_includedir/%rname-%api_version
%_libdir/*.so
%_libdir/%rname-%api_version
%_pkgconfigdir/*.pc

%if_enabled docs
%files doc
%_datadir/devhelp/books/%rname-%api_version
%_docdir/%rname-%api_version
%endif

%changelog
