%define _unpackaged_files_terminate_build 1

%define soversion 2501.0.0

# about -DCMAKE_CXX_STANDARD=17 see https://github.com/desktop-app/tg_owt/pull/55#discussion_r599718405
# from tg_owt: HINT: System abseil should be built with -DCMAKE_CXX_STANDARD=20
%define cxx_standard 17

# Can't be build with packaged GTest: https://github.com/abseil/abseil-cpp/issues/1102
# And these tests are very long
%ifarch %e2k
%def_disable check
%else
%def_enable check
%endif

Name: libabseil-cpp
Version: 20250127.1
Release: alt2

Summary: C++ Common Libraries

License: Apache-2.0
Group: Development/C++
Url: https://abseil.io
VCS: https://github.com/abseil/abseil-cpp
Source: %name-%version.tar

BuildRequires(pre): rpm-macros-cmake
BuildRequires: cmake ninja-build
BuildRequires: gcc-c++
BuildRequires: /proc

# needed for test helpers
BuildRequires: libgtest-devel >= 1.13.0

%if_enabled check
BuildRequires: libgmock-devel ctest
%endif

# https://bugzilla.altlinux.org/42411
Conflicts: libclickhouse-cpp-devel <= 1.2.2-alt1

%description
Abseil is an open-source collection of C++ library code designed to augment
the C++ standard library. The Abseil library code is collected from
Google's own C++ code base, has been extensively tested and used in
production, and is the same code we depend on in our daily coding lives.

In some cases, Abseil provides pieces missing from the C++ standard; in
others, Abseil provides alternatives to the standard for special needs we've
found through usage in the Google code base. We denote those cases clearly
within the library code we provide you.

Abseil is not meant to be a competitor to the standard library; we've just
found that many of these utilities serve a purpose within our code base,
and we now want to provide those resources to the C++ community as a whole.

%package -n libabseil-cpp%soversion
Summary: %summary
Group: Development/C++

%description -n  libabseil-cpp%soversion
Abseil is an open-source collection of C++ library code designed to augment
the C++ standard library. The Abseil library code is collected from
Google's own C++ code base, has been extensively tested and used in
production, and is the same code we depend on in our daily coding lives.

In some cases, Abseil provides pieces missing from the C++ standard; in
others, Abseil provides alternatives to the standard for special needs we've
found through usage in the Google code base. We denote those cases clearly
within the library code we provide you.

Abseil is not meant to be a competitor to the standard library; we've just
found that many of these utilities serve a purpose within our code base,
and we now want to provide those resources to the C++ community as a whole.



%package testing
Summary:        Libraries needed for running tests on the installed %name
Requires:       libabseil-cpp%soversion = %EVR
Group: Development/C++

%description testing
%{summary}.


%package devel
Summary: Development files for %name
Requires: libabseil-cpp%soversion = %EVR
Group: Development/C++

%description devel
Development headers for %name

%prep
%setup
%ifarch %e2k
# C++20 specific problem
sed -E -i "s/(ABSL_CONST_INIT (|extern )thread_local)( int64_t)/\2__thread\3/" \
	absl/strings/internal/cordz_functions.{h,cc}
# missing builtins
sed -i 's/ABSL_HAVE_BUILTIN(__builtin_c[tl]zs)/0/' absl/numeric/internal/bits.h
%endif

%build
%add_optflags -fPIC
%cmake \
    -DCMAKE_BUILD_TYPE:STRING=RelWithDebInfo \
    -DBUILD_SHARED_LIBS:BOOL=ON \
    -DCMAKE_CXX_STANDARD:STRING=%cxx_standard \
    -DABSL_ENABLE_INSTALL:BOOL=ON \
    -DCMAKE_POSITION_INDEPENDENT_CODE:BOOL=ON \
%if_enabled check
    -DABSL_BUILD_TESTING:BOOL=ON \
%endif
    -DABSL_BUILD_TEST_HELPERS:BOOL=ON \
    -DABSL_USE_EXTERNAL_GOOGLETEST:BOOL=ON \
    -DABSL_FIND_GOOGLETEST:BOOL=ON \
    -GNinja
%cmake_build

%check
%ifarch x86_64 aarch64
ctest --test-dir %_cmake__builddir --output-on-failure --force-new-ctest-process %_smp_mflags
%else
ctest --test-dir %_cmake__builddir --output-on-failure --force-new-ctest-process %_smp_mflags ||:
%endif

%install
%cmake_install


%files -n libabseil-cpp%soversion
%doc LICENSE
%doc FAQ.md README.md UPGRADES.md

%_libdir/libabsl_bad_any_cast_impl.so.%soversion
%_libdir/libabsl_bad_optional_access.so.%soversion
%_libdir/libabsl_bad_variant_access.so.%soversion
%_libdir/libabsl_base.so.%soversion
%_libdir/libabsl_city.so.%soversion
%_libdir/libabsl_civil_time.so.%soversion
%_libdir/libabsl_cord.so.%soversion
%_libdir/libabsl_cord_internal.so.%soversion
%_libdir/libabsl_cordz_functions.so.%soversion
%_libdir/libabsl_cordz_handle.so.%soversion
%_libdir/libabsl_cordz_info.so.%soversion
%_libdir/libabsl_cordz_sample_token.so.%soversion
%_libdir/libabsl_crc32c.so.%soversion
%_libdir/libabsl_crc_cord_state.so.%soversion
%_libdir/libabsl_crc_cpu_detect.so.%soversion
%_libdir/libabsl_crc_internal.so.%soversion
%_libdir/libabsl_debugging_internal.so.%soversion
%_libdir/libabsl_decode_rust_punycode.so.%soversion
%_libdir/libabsl_demangle_internal.so.%soversion
%_libdir/libabsl_demangle_rust.so.%soversion
%_libdir/libabsl_die_if_null.so.%soversion
%_libdir/libabsl_examine_stack.so.%soversion
%_libdir/libabsl_exponential_biased.so.%soversion
%_libdir/libabsl_failure_signal_handler.so.%soversion
%_libdir/libabsl_flags_commandlineflag.so.%soversion
%_libdir/libabsl_flags_commandlineflag_internal.so.%soversion
%_libdir/libabsl_flags_config.so.%soversion
%_libdir/libabsl_flags_internal.so.%soversion
%_libdir/libabsl_flags_marshalling.so.%soversion
%_libdir/libabsl_flags_parse.so.%soversion
%_libdir/libabsl_flags_private_handle_accessor.so.%soversion
%_libdir/libabsl_flags_program_name.so.%soversion
%_libdir/libabsl_flags_reflection.so.%soversion
%_libdir/libabsl_flags_usage.so.%soversion
%_libdir/libabsl_flags_usage_internal.so.%soversion
%_libdir/libabsl_graphcycles_internal.so.%soversion
%_libdir/libabsl_hash.so.%soversion
%_libdir/libabsl_hashtablez_sampler.so.%soversion
%_libdir/libabsl_int128.so.%soversion
%_libdir/libabsl_kernel_timeout_internal.so.%soversion
%_libdir/libabsl_leak_check.so.%soversion
%_libdir/libabsl_log_entry.so.%soversion
%_libdir/libabsl_log_flags.so.%soversion
%_libdir/libabsl_log_globals.so.%soversion
%_libdir/libabsl_log_initialize.so.%soversion
%_libdir/libabsl_log_internal_check_op.so.%soversion
%_libdir/libabsl_log_internal_conditions.so.%soversion
%_libdir/libabsl_log_internal_fnmatch.so.%soversion
%_libdir/libabsl_log_internal_format.so.%soversion
%_libdir/libabsl_log_internal_globals.so.%soversion
%_libdir/libabsl_log_internal_log_sink_set.so.%soversion
%_libdir/libabsl_log_internal_message.so.%soversion
%_libdir/libabsl_log_internal_nullguard.so.%soversion
%_libdir/libabsl_log_internal_proto.so.%soversion
%_libdir/libabsl_log_internal_structured_proto.so.%soversion
%_libdir/libabsl_log_severity.so.%soversion
%_libdir/libabsl_log_sink.so.%soversion
%_libdir/libabsl_low_level_hash.so.%soversion
%_libdir/libabsl_malloc_internal.so.%soversion
%_libdir/libabsl_periodic_sampler.so.%soversion
%_libdir/libabsl_poison.so.%soversion
%_libdir/libabsl_random_distributions.so.%soversion
%_libdir/libabsl_random_internal_distribution_test_util.so.%soversion
%_libdir/libabsl_random_internal_platform.so.%soversion
%_libdir/libabsl_random_internal_pool_urbg.so.%soversion
%_libdir/libabsl_random_internal_randen.so.%soversion
%_libdir/libabsl_random_internal_randen_hwaes.so.%soversion
%_libdir/libabsl_random_internal_randen_hwaes_impl.so.%soversion
%_libdir/libabsl_random_internal_randen_slow.so.%soversion
%_libdir/libabsl_random_internal_seed_material.so.%soversion
%_libdir/libabsl_random_seed_gen_exception.so.%soversion
%_libdir/libabsl_random_seed_sequences.so.%soversion
%_libdir/libabsl_raw_hash_set.so.%soversion
%_libdir/libabsl_raw_logging_internal.so.%soversion
%_libdir/libabsl_scoped_set_env.so.%soversion
%_libdir/libabsl_spinlock_wait.so.%soversion
%_libdir/libabsl_stacktrace.so.%soversion
%_libdir/libabsl_status.so.%soversion
%_libdir/libabsl_status_matchers.so.%soversion
%_libdir/libabsl_statusor.so.%soversion
%_libdir/libabsl_str_format_internal.so.%soversion
%_libdir/libabsl_strerror.so.%soversion
%_libdir/libabsl_strings.so.%soversion
%_libdir/libabsl_string_view.so.%soversion
%_libdir/libabsl_strings_internal.so.%soversion
%_libdir/libabsl_symbolize.so.%soversion
%_libdir/libabsl_synchronization.so.%soversion
%_libdir/libabsl_throw_delegate.so.%soversion
%_libdir/libabsl_time.so.%soversion
%_libdir/libabsl_time_zone.so.%soversion
%_libdir/libabsl_tracing_internal.so.%soversion
%_libdir/libabsl_utf8_for_code_point.so.%soversion
%_libdir/libabsl_vlog_config_internal.so.%soversion

%files testing
%_libdir/libabsl_scoped_mock_log.so.%soversion
%if_enabled check
# TESTONLY libraries (that are actually installed):
# absl/base/CMakeLists.txt
%_libdir/libabsl_exception_safety_testing.so.%soversion
%_libdir/libabsl_atomic_hook_test_helper.so.%soversion
%_libdir/libabsl_spinlock_test_common.so.%soversion
# absl/container/CMakeLists.txt
%_libdir/libabsl_test_instance_tracker.so.%soversion
%_libdir/libabsl_hash_generator_testing.so.%soversion
# absl/debugging/CMakeLists.txt
%_libdir/libabsl_stack_consumption.so.%soversion
# absl/log/CMakeLists.txt
%_libdir/libabsl_log_internal_test_actions.so.%soversion
%_libdir/libabsl_log_internal_test_helpers.so.%soversion
%_libdir/libabsl_log_internal_test_matchers.so.%soversion
# absl/strings/CMakeLists.txt
%_libdir/libabsl_pow10_helper.so.%soversion
# absl/synchronization/CMakeLists.txt
%_libdir/libabsl_per_thread_sem_test_common.so.%soversion
# absl/time/CMakeLists.txt
%_libdir/libabsl_time_internal_test_util.so.%soversion
%endif

%files devel
%doc LICENSE
%doc *.md
%_libdir/libabsl_*.so
#files devel
%_includedir/absl/
%_libdir/cmake/absl/
%_pkgconfigdir/*.pc

%changelog
