Name: libX11
Version: 1.8.11
Release: alt1
Epoch: 3
Summary: X11 Library
License: MIT/X11
Group: System/Libraries
Url: http://xorg.freedesktop.org
Packager: Valery Inozemtsev <shrek@altlinux.ru>

PreReq: filesystem > 2.3.1-alt1
Requires: %name-locales = %version-%release
Provides: %name-ccache = %version-%release
Obsoletes: %name-ccache < %version-%release

Source: %name-%version.tar
Patch: %name-%version-%release.patch

BuildRequires: libxcb-devel perl-Pod-Parser xorg-proto-devel xorg-util-macros xmlto xorg-sgml-doctools xorg-xtrans-devel

%description
X11 Library

%package devel
Summary: X11 Libraries and Header Files
Group: Development/C
Requires: %name = %version-%release

%description devel
%name-devel contains the libraries and header files needed to
develop programs which make use of %name

%package locales
Summary: Xorg locales
Group: System/Internationalization
BuildArch: noarch
Conflicts: %name <= 1.1.1-alt2

%description locales
This package contains set of Xorg locales

%def_enable ipv6
%def_disable loadable_i18n
%def_disable xlocaledir

%prep
%setup -q

%patch -p1

%build
%autoreconf
%configure \
	%{subst_enable ipv6} \
	%{subst_enable loadable_i18n} \
	%{subst_enable xlocaledir} \
	--disable-specs \
	--disable-static
%make_build

%install
%make DESTDIR=%buildroot install

%if_enabled loadable_i18n
rm -f %buildroot%_libdir/X11/locale/common/*.la
%endif

%files
%doc AUTHORS COPYING README.md
%_libdir/*.so.*
%if_enabled loadable_i18n
%_libdir/X11/locale
%endif
%dir %_datadir/X11
%_datadir/X11/X*
%_man5dir/*.5*

%files devel
%_includedir/X11/*
%_libdir/*.so
%_pkgconfigdir/*.pc
%_man3dir/*.3*

%files locales
%_datadir/X11/locale

%changelog
