%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

%def_without python3
# dane_ta_usage requires openssl >= 1.1.0
%def_with dane_ta_usage

Name: ldns
Version: 1.8.4
Release: alt1

Summary: Lowlevel DNS(SEC) library with API

License: BSD
Group: System/Libraries
URL: https://www.nlnetlabs.nl/projects/ldns
VCS: https://github.com/NLnetLabs/ldns

Source: %name-%version.tar

BuildRequires: gcc-c++ libssl-devel doxygen perl libpcap-devel
%if_with python3
BuildRequires: python3-devel swig
%endif

%description
ldns is a library with the aim to simplify DNS programing in C. All
lowlevel DNS/DNSSEC operations are supported. We also define a higher
level API which allows a programmer to (for instance) create or sign
packets.

%package -n drill
Summary: Drill  is a tool to designed to get all sorts of information out of the DNS
Group: Networking/DNS

%description -n drill
Drill  is a tool to designed to get all sorts of information out of the DNS. 
It is specificly designed to be used with DNSSEC

The name drill is a pun on dig. With drill you should be able get  even
more information than with dig.

%package -n lib%name
Summary: Lowlevel DNS(SEC) library with API
Group: System/Libraries
Provides: %name = %EVR

%description -n lib%name
libldns is a library with the aim to simplify DNS programing in C. All
lowlevel DNS/DNSSEC operations are supported. We also define a higher
level API which allows a programmer to (for instance) create or sign
packets.

%package -n lib%name-devel
Summary: Development package that includes the ldns header files
Group: Development/C
Requires: lib%name = %EVR
Requires: libssl-devel

%description -n lib%name-devel
The devel package contains the ldns library and the include files

%package -n lib%name-examples
Summary: Examples for library
Group: Development/C

%description -n lib%name-examples
Examples for library

%if_with python3
%package -n python3-module-%name
Summary: Python extensions for ldns
Group: Development/Python3

%description -n python3-module-%name
Python extensions for ldns
%endif

%prep
%setup

%build
%add_optflags -D_FILE_OFFSET_BITS=64

%autoreconf
%configure \
	--disable-rpath \
	--disable-static \
	--with-drill \
	--with-examples \
	--enable-rrtype-ninfo \
	--enable-rrtype-rkey \
	--enable-rrtype-cds \
	--enable-rrtype-uri \
	--enable-rrtype-ta \
%if_with python3
	--with-pyldns \
	PYTHON=$(which python3) \
%endif
%if_without dane_ta_usage
	--disable-dane-ta-usage \
%endif
	%nil

%make_build
%make doc

%install
%make DESTDIR=%buildroot install
%make DESTDIR=%buildroot install-doc


# don't package building script in doc
rm doc/doxyparse.pl
#remove doc stubs
rm -rf doc/.svn
#remove double set of man pages
rm -rf doc/man
# remove .la files
rm -rf %buildroot%python3_sitelibdir/*.la

install -pD -m644 packaging/libldns.pc %buildroot%_pkgconfigdir/libldns.pc
install -pD -m644 libdns.vim %buildroot%_sysconfdir/vim/libldns

%check
#make test

%files -n drill
%_bindir/drill
%_mandir/man1/drill*

%files -n lib%name
%_libdir/libldns*.so.*
%doc README LICENSE

%files -n lib%name-devel
%_bindir/ldns-config
%_man1dir/ldns-config*
%_includedir/ldns
%_pkgconfigdir/*
%_libdir/libldns*so
%doc doc Changelog README
%_man3dir/*
%_sysconfdir/vim/*

%files -n lib%name-examples
%_bindir/ldns-*
%_bindir/ldnsd
%_man1dir/ldns-*
%_man1dir/ldnsd*

%exclude %_bindir/ldns-config
%exclude %_man1dir/ldns-config*

%if_with python3
%files -n python3-module-%name
%python3_sitelibdir/*.py
%python3_sitelibdir/*.so*
%python3_sitelibdir/__pycache__/*
%endif

%changelog
