Group: Sound
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           ladspa-caps-plugins
Version:        0.9.24
Release:        alt4_22
Summary:        The C* Audio Plugin Suite
# Automatically converted from old format: GPLv3+ - review is highly recommended.
License:        GPL-3.0-or-later
URL:            http://quitte.de/dsp/caps.html
Source0:        http://quitte.de/dsp/caps_%{version}.tar.bz2
Patch0:         caps-0.9.10-nostrip.patch
Patch1:         caps-0.9.24-gcc6.patch
Patch2:         caps-pow-exp.patch
BuildRequires:  gcc-c++
BuildRequires:  ladspa_sdk
Requires:       ladspa_sdk
Obsoletes:      caps <= 0.3.0-2
Provides:       caps = %{version}-%{release}
Source44: import.info
Patch33: caps-0.9.24-alt-e2k.patch
Conflicts: ladspa-caps < 0.4.3
Obsoletes: ladspa-caps < 0.4.3
Provides: ladspa-caps = %version

%description
caps, the C* Audio Plugin Suite, is a collection of refined LADSPA
units including instrument amplifier emulation, stomp-box classics,
versatile 'virtual analog' oscillators, fractal oscillation, reverb,
equalization and others.


%prep
%setup -q -n caps-%{version}
%patch0  -p1 -z .nostrip
%patch1  -p1
%patch2  -p1
# use the system version of ladspa.h
rm ladspa.h
%patch33 -p1


%build
%ifarch %e2k
# mcst#4314
%add_optflags -D__builtin_cosf=cosf -D__builtin_sinf=sinf
%endif
%make_build OPTS="%optflags -fPIC" LDFLAGS="$RPM_LD_FLAGS -shared"


%install
%makeinstall_std DEST=%{_libdir}/ladspa


%files
%doc CHANGES README*
%doc --no-dereference COPYING
%{_libdir}/ladspa/*.so
%{_datadir}/ladspa/rdf/*


%changelog
