%define rev 403d516

Name: kraft
Version: 2.0.0
Release: alt0.git%rev

Summary: Kraft - Software for small business
Summary(ru_RU.UTF-8): Kraft — программное обеспечение для малого бизнеса
License: GPL-2.0
Group: Office
# VCS: https://github.com/dragotin/kraft
URL: http://www.volle-kraft-voraus.de/

Requires: kde5-akonadi

Source0: kraft-%version.tar
Patch0: kraft-alt-fix-link.patch

BuildRequires(pre): rpm-build-kf6
BuildRequires(pre): rpm-build-python3
BuildRequires: extra-cmake-modules gcc-c++
BuildRequires: qt6-declarative-devel
BuildRequires: kf6-kcodecs-devel
BuildRequires: kf6-kconfig-devel
BuildRequires: kf6-kcontacts-devel
BuildRequires: kf6-kcoreaddons-devel
BuildRequires: kf6-ki18n-devel
BuildRequires: kf6-ktexttemplate-devel
BuildRequires: kf6-kxmlgui-devel
BuildRequires: libctemplate-devel
BuildRequires: grantlee5-devel
BuildRequires: qt6-svg-devel

%py3_requires reportlab

%description
Kraft is free software to help to handle documents like quotes and invoices in
your small business.

%prep
%setup -q -n %name-%version
%patch0 -p1
subst 's|LIBRARY DESTINATION lib/kraft|LIBRARY DESTINATION ${LIB_INSTALL_DIR}|' src/CMakeLists.txt
echo "%rev" > .tag

%build
%K6init no_altplace
%K6build -DCMAKE_SKIP_RPATH=1 \
         -DKDE_INSTALL_KXMLGUIDIR=%_datadir/kxmlgui6

%install
%K6install
%find_lang --with-kde %name

%files -f %name.lang
%doc AUTHORS README.md TODO Changes.txt
%_bindir/*
%_datadir/%name
%_K6xdgapp/*.desktop
%_iconsdir/*/*/*/*.svg
%_iconsdir/hicolor/scalable/apps/%name.svg
%_K6xmlgui/%name
%_datadir/metainfo/*.appdata.xml

%changelog 
