%define _unpackaged_files_terminate_build 1

Name: kmscon
Version: 9.1.0
Release: alt1
Summary: KMS/DRM based System Console
Group: Terminals

License: MIT and LGPLv2+
Url: http://www.freedesktop.org/wiki/Software/kmscon/
Source: %name-%version.tar
Patch1: %name-%version.patch

BuildRequires(pre): rpm-macros-meson
BuildRequires: meson >= 1.1
BuildRequires: pkgconfig(xkbcommon)
BuildRequires: xkeyboard-config
BuildRequires: pkgconfig(libtsm) >= 4.0.0
BuildRequires: pkgconfig(libudev) >= 172
BuildRequires: pkgconfig(libdrm)
BuildRequires: libsystemd-devel pkgconfig(libsystemd)
BuildRequires: pkgconfig(gbm)
BuildRequires: pkgconfig(egl)
BuildRequires: pkgconfig(glesv2)
BuildRequires: pkgconfig(pango) pkgconfig(pangoft2)
BuildRequires: pkgconfig(pixman-1)
BuildRequires: pkgconfig(check)
BuildRequires: xsltproc docbook-style-xsl docbook-dtds

%description
Kmscon is a simple terminal emulator based on Linux kernel mode setting (KMS).
It is an attempt to replace the in-kernel VT implementation with a user-space
console. See kmscon(1) man-page for usage information.

%prep
%setup
%patch1 -p1

%build
# Patch out tests we have to skip.
sed -i /"'"output"'"/c"# 'output' needs /dev/dri/card*" tests/meson.build
sed -i /"'"vt"'"/c"# 'vt' hangs in hasher" tests/meson.build

%meson
%meson_build

%install
%meson_install

%check
%meson_test

%files
%doc COPYING NEWS README.md
%_bindir/%name
%_unitdir/*.service
%dir %_libdir/%name
%_libdir/%name/mod-*.so
%dir %_libexecdir/kmscon
%_libexecdir/kmscon/kmscon
%_man1dir/%name.1*

%changelog
