%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

Name: kmod
Version: 34.2
Release: alt2
Summary: Linux kernel module handling

Group: System/Kernel and hardware
License: GPL-2.0-or-later AND LGPL-2.1-or-later
Url: https://git.kernel.org/pub/scm/utils/kernel/kmod/kmod.git/about/
ExclusiveOS: Linux
Requires: lib%name = %EVR

Source0: %name-%version.tar

BuildRequires: bash-completion
BuildRequires: glibc-devel-static
BuildRequires: liblzma-devel
BuildRequires: libssl-devel
BuildRequires: libzstd-devel
BuildRequires: scdoc
BuildRequires: zlib-devel
%{?!_without_check:%{?!_disable_check:
BuildRequires: kernel-headers-modules-latest
}}

Provides: module-init-tools = 3.17-alt1
Obsoletes: module-init-tools
Conflicts: module-init-tools-compat
Conflicts: filesystem < 3
Provides: /bin/kmod /bin/lsmod
Provides: /sbin/depmod /sbin/insmod /sbin/lsmod /sbin/modinfo /sbin/modprobe /sbin/rmmod
Obsoletes: bash-completion-%name

%description
kmod is a set of tools to handle common tasks with Linux kernel modules like
insert, remove, list, check properties, resolve dependencies and aliases.

%package -n lib%name
Summary: Libraries to handle kernel module loading and unloading
License: LGPL-2.1-or-later
Group: System/Kernel and hardware
Provides: %name-libs = %EVR

%description -n lib%name
The kmod-libs package provides runtime libraries for any application that
wishes to load or unload Linux kernel modules from the running system.

%package -n lib%name-devel
Summary: Header files for kmod development
Group: Development/C
License: LGPL-2.1-or-later
Requires: lib%name = %EVR
Provides: %name-devel = %EVR

%description -n lib%name-devel
The libkmod-devel package provides header files used for development of
applications that wish to load or unload Linux kernel modules.

%package checkinstall
Summary: Smoke test for %name
Group: Development/Other
Requires(post): %name = %EVR
Requires(post): rpm-build-vm

%description checkinstall
%summary.

%prep
%setup

%build
touch libkmod/docs/gtk-doc.make
%autoreconf

%configure \
    --disable-static \
    --with-openssl \
    --with-zlib \
    --with-xz \
    --with-zstd \
    %nil
%make_build

%install
%make_install DESTDIR=%buildroot install
rm -r %buildroot%_libdir/*.la

# New configuration files we ship (if any) should go into /usr/lib/modprobe.d
# in order to allow the local sysadmin to customize /etc/modprobe.d
mkdir -p %buildroot/{%_sysconfdir,%prefix/lib}/modprobe.d
mkdir -p %buildroot/{%_sysconfdir,%prefix/lib}/depmod.d

# Add blacklists from module-init-tools
find rpm/modprobe.d -maxdepth 1 -type f -name '*.conf' -print0 |
    xargs -r0 install -m644 -p -t %buildroot%_modprobedir/ --

%ifarch %ix86 x86_64
install -m644 -p rpm/modprobe.d/arch/i386.conf %buildroot%_modprobedir/arch.conf
%endif

# Make compatibility symlinks
ln -s kmod -T %buildroot%_bindir/lsmod

# cleanup non-root access utils
rm -f %buildroot%_bindir/{depmod,insmod,modinfo,modprobe,rmmod}

%check
%make check V=1 KDIR=/lib/modules/*/build

%post checkinstall
set -ex
timeout 999 \
vm-run --ext4 --sbin -ex --heredoc <<-EOF
	depmod
	/sbin/modprobe configs
	modprobe dm-verity require_signatures=1
	grep -x Y /sys/module/dm_verity/parameters/require_signatures
	modprobe -a dm-verity
EOF
rm -f /tmp/initramfs-*.img /tmp/vm-ext4.img /tmp/vm.*

%files
%doc NEWS README.md tools/COPYING
%dir %_sysconfdir/depmod.d
%dir %_sysconfdir/modprobe.d
%dir %prefix/lib/depmod.d
%dir %_modprobedir
%_modprobedir/*.conf
%_bindir/kmod
%_bindir/lsmod
%_sbindir/depmod
%_sbindir/insmod
%_sbindir/lsmod
%_sbindir/modinfo
%_sbindir/modprobe
%_sbindir/rmmod
%_man5dir/*
%_man8dir/*
%_datadir/bash-completion/completions/*
%_datadir/fish/vendor_functions.d/*
%_datadir/zsh/site-functions/*

%files -n lib%name
%_libdir/libkmod.so.*

%files -n lib%name-devel
%doc libkmod/COPYING libkmod/README
%_includedir/libkmod.h
%_pkgconfigdir/libkmod.pc
%_libdir/libkmod.so
%_datadir/pkgconfig/%name.pc

%files checkinstall

%changelog
