%define rname kig
%add_python3_path %_K6bin
%add_findreq_skiplist %_K6bin/pykig.py
%define add_python3_requires() %(echo -n "Requires: "; for p in %*; do echo -n "python3($p) "; done; echo)

Name: %rname
Version: 25.08.2
Release: alt1
%K6init

Group: Education
Summary: Interactive Geometry
Url: http://www.kde.org
License: GPL-2.0-or-later and LGPL-2.1-or-later

%add_python3_requires traceback os math getopt xml.sax.saxutils
Provides:  kde5-kig = %EVR
Obsoletes: kde5-kig < %EVR

Source: %rname-%version.tar

BuildRequires(pre): rpm-build-kf6 rpm-build-python3
BuildRequires: extra-cmake-modules qt6-declarative-devel qt6-svg-devel
BuildRequires: boost-devel-headers boost-python3-devel
BuildRequires: kf6-karchive-devel kf6-kauth-devel kf6-kbookmarks-devel kf6-kcodecs-devel kf6-kcompletion-devel
BuildRequires: kf6-kconfig-devel kf6-kconfigwidgets-devel kf6-kcoreaddons-devel  kf6-kdoctools-devel
BuildRequires: kf6-ki18n-devel kf6-kiconthemes-devel kf6-kio-devel kf6-kitemmodels-devel kf6-kitemviews-devel
BuildRequires: kf6-kjobwidgets-devel kf6-kparts-devel kf6-kservice-devel kf6-ktexteditor-devel kf6-ktextwidgets-devel kf6-kwidgetsaddons-devel
BuildRequires: kf6-kxmlgui-devel kf6-solid-devel kf6-sonnet-devel kf6-kcrash-devel kf6-syntax-highlighting-devel

%description
Kig is a program for exploring geometric constructions.


%prep
%setup -n %rname-%version
sed -i '1d' pykig/pykig.py
sed -i '1i#!%__python3' pykig/pykig.py
#sed -i -E '/[[:space:]]except[[:space:]]+.*,.*/s/(^.*except[[:space:]]+)([[:alpha:]].*):$/\1(\2):/' pykig/pykig.py

%build
PY3_VER_WO_DOTS=`echo "%_python3_abi_version"| sed 's|\.||g'`
%K6build \
    -DPYTHON_EXECUTABLE:PATH=%__python3 \
    -DPYTHON_INCLUDE_DIR=%__python3_includedir \
    -DPYTHON_LIBRARY=%__libpython3 \
    -DBoostPython_INCLUDE_DIRS="%__python3_includedir;%_includedir/boost" \
    -DBoostPython_LIBRARIES="%__libpython3;%_libdir/libboost_python${PY3_VER_WO_DOTS}.so" \
    #

%install
%K6install
%K6install_move data kig katepart
%find_lang %name --with-kde --all-name

%files -f %name.lang
%doc LICENSES/*
%_K6bin/kig
%_K6bin/pykig.py
%_K6plug/kf6/parts/*kig*.so
%_K6data/kig/
%_datadir/katepart5/syntax/*-kig.xml
%_K6icon/*/*/apps/kig.*
%_K6icon/*/*/mimetypes/application-x-kig.*
%_K6xdgapp/org.kde.kig.desktop
%_datadir/metainfo/*.xml

%changelog
