# Unpackaged files in buildroot should terminate build
%define _unpackaged_files_terminate_build 1

%define majver 9.0

Name: kicad
Version: 9.0.6
Release: alt1
Epoch: 1

Summary: An open source software for the creation of electronic schematic diagrams
Summary(ru_RU.UTF-8): Программа с открытым исходным кодом для проектирования электронных схем
License: AGPL-3.0-or-later
Group: Engineering

Url: https://gitlab.com/kicad/code/kicad.git
Source: %name-%version.tar
Patch: %name-%version-%release.patch
Patch1000: kicad-e2k.patch

ExcludeArch: %arm

BuildRequires(pre): rpm-macros-cmake
BuildRequires(pre): rpm-macros-python3
BuildRequires: cmake
BuildRequires: rpm-build-python3
BuildRequires: python3-dev
BuildRequires: python3-module-wx
BuildRequires: boost-devel
BuildRequires: boost-asio-devel
BuildRequires: boost-asio-devel
BuildRequires: boost-context-devel
BuildRequires: boost-filesystem-devel
BuildRequires: boost-geometry-devel
BuildRequires: boost-interprocess-devel
BuildRequires: boost-locale-devel
BuildRequires: boost-program_options-devel
BuildRequires: ccmake gcc-c++
BuildRequires: libwxGTK3.2-devel
BuildRequires: libgtk+3-devel
BuildRequires: libGLEW-devel
BuildRequires: libcairo-devel
BuildRequires: libssl-devel
BuildRequires: libprotobuf-devel
BuildRequires: protobuf-compiler
BuildRequires: swig
BuildRequires: pkgconfig(gobject-2.0)
BuildRequires: libpcre-devel
BuildRequires: libpixman-devel
BuildRequires: pkgconfig(harfbuzz)
BuildRequires: pkgconfig(expat)
BuildRequires: pkgconfig(libdrm)
BuildRequires: pkgconfig(xdmcp)
BuildRequires: pkgconfig(xdamage)
BuildRequires: pkgconfig(xxf86vm)
BuildRequires: pkgconfig(libsecret-1)
BuildRequires: libwayland-client-devel
BuildRequires: libwayland-server-devel
BuildRequires: libwayland-cursor-devel
BuildRequires: libwayland-egl-devel
BuildRequires: libcurl-devel
BuildRequires: libgit2-devel
BuildRequires: libunixODBC-devel
BuildRequires: libzstd-devel
BuildRequires: doxygen graphviz
BuildRequires: dos2unix
BuildRequires: libglm-devel
BuildRequires: libuuid-devel
BuildRequires: ngspice-devel
BuildRequires: opencascade-devel
BuildRequires: openmpi-devel
BuildRequires: ImageMagick-tools
BuildRequires: desktop-file-utils
#Requires: kicad-packages3D >= %majver
Requires: kicad-symbols >= %majver
Requires: kicad-footprints >= %majver
Requires: kicad-templates >= %majver
Requires: %name-doc >= %epoch:%majver
Requires: %name-common >= %EVR
Requires: ngspice

%add_python3_path %_datadir/%name

%description
Kicad is an open source (GPL) software for the creation of electronic
schematic diagrams and printed circuit board artwork.

Kicad is a set of four softwares and a project manager:

Kicad: Project manager.
Eeschema: Schematic entry.
Pcbnew: Board editor.
Cvpcb: Footprint selector for components used in the circuit design.
Gerbview: GERBER viewer (photoplotter documents).

%description -l ru_RU.UTF-8
Kicad - это программное обеспечение с открытым исходным кодом для
проектирования электронных схем и получения на их основе печатных плат.

Включает в себя редактор схем, средство трассировки печатных плат,
средства трёхмерного просмотра печатных плат в конечном виде.

Kicad состоит из 5 основных компонентов:

 * kicad — менеджер проектов
 * eeschema — редактор схем
 * pcbnew — редактор печатных плат
 * gerbview — просмотр GERBER
 * cvpcb — выбор мест для компонентов

На заметку:
Для использования рамки ГОСТ необходимо выбрать шаблон
gost_landscape.kicad_wks или gost_portrait.kicad_wks в диалоговом окне
"Настройки страницы" в поле "Файл описания разметки листа".
Стандартные файлы рамки (*.kicad_wks) находятся в %_datadir/kicad/template/.

%package common
Summary: Common package for kicad
Group: Engineering

BuildArch: noarch

Obsoletes: kicad-data <= %EVR
Obsoletes: kicad-i18n <= %EVR

%description common
Common package for kicad.

%prep
%setup
%patch -p1

%ifarch %e2k
%patch2000 -p1
sed -i "s/-Wreturn-type/-Wbuggy-edg/" cmake/Warnings.cmake
sed -i "s/';'/']'/" thirdparty/pegtl/pegtl/demangle.hpp
sed -i "s/m_currentSymbol.GetSubLibraryName()/((wxString)&)/" eeschema/symbol_viewer_frame.cpp
%endif

%build
%ifarch %e2k
# LCC produces an insane amount of debug info (14Gb)
# -g1 is the same as default
%define optflags_debug -g0
%endif
%cmake \
    %_cmake_skip_rpath \
    -DPYTHON_SITE_PACKAGE_PATH=%python3_sitelibdir \
    -DKICAD_SCRIPTING_WXPYTHON=ON \
    -DKICAD_USE_EGL=ON \
    -DKICAD_USE_CMAKE_FINDPROTOBUF=OFF \
    -DKICAD_IPC_API=OFF \
    -DKICAD_WAYLAND=ON \
    -DKICAD_BUILD_I18N=ON \
    -DKICAD_I18N_UNIX_STRICT_PATH=ON \
    -DKICAD_VERSION_EXTRA=%release \
    -DCMAKE_CXX_FLAGS_RELWITHDEBINFO="-DNDEBUG" \
    -DCMAKE_BUILD_TYPE=RelWithDebInfo

%cmake_build

%install
%cmake_install

#fix line ending
dos2unix %buildroot%_desktopdir/*.desktop

#validate desktop files
desktop-file-validate %buildroot%_desktopdir/*.desktop
for i in %buildroot%_desktopdir/*.desktop; do
	desktop-file-install --dir %buildroot%_desktopdir \
		--add-category=Engineering \
		"$i"
done

%find_lang %name

%files -f %name.lang
%_bindir/*
%_desktopdir/*.desktop
%_libdir/*.so*
%_libdir/%name/
%python3_sitelibdir/_pcbnew.so
%python3_sitelibdir/pcbnew.py
%python3_sitelibdir/__pycache__/pcbnew*
#doc %_docdir/%name
%_datadir/metainfo/*.metainfo.xml
%_iconsdir/hicolor/*/mimetypes/application-x-*.*
%_iconsdir/hicolor/*/apps/*.*
%_datadir/%name/
%_datadir/mime/packages/*

%files common
%dir %_datadir/kicad
%dir %_datadir/kicad/template

%changelog
