%define rname oxygen-icons

Name: kf5-oxygen-icons
Version: 6.1.0
Release: alt1
%K6init no_altplace

Group: Graphical desktop/KDE
Summary: Oxygen icons theme
Url: http://www.kde.org
License: LGPL-2.1-or-later

BuildArch: noarch

Source: %rname-%version.tar
Patch1: alt-icons-defaults.patch

BuildRequires(pre): rpm-build-kf6
BuildRequires: extra-cmake-modules gcc-c++ qt6-base-devel
BuildRequires: icon-naming-utils

%description
%summary

%package -n icon-theme-oxygen
Summary: Oxygen icons theme
Group: Graphics
%description -n icon-theme-oxygen
%summary


%prep
%setup -n %rname-%version
%patch1 -p1

%build
%K6build

%install
%K6install

# 6971
for t in %buildroot/%_iconsdir/* ; do
    [ -d $t ] || continue
    pushd $t
	ls -1d * | \
	while read sz ; do
	    [ -d $sz ] || continue
	    pushd $sz
	    ls -1d * | \
	    while read ctx ; do
		[ -d $ctx ] || continue
		%_libexecdir/icon-name-mapping -c $ctx
	    done
	    popd
	done
    popd
done

# fix broken symlinks
find %buildroot/%_iconsdir -type l | \
while read l ; do
    [ -e $l ] || rm -f $l
done

# clean "package" icon
if [ -z "`find %buildroot/%_iconsdir -name package-installed-updated.\*`" ] ; then
    find %buildroot/%_iconsdir -name package.\* | \
    while read f ; do
	rm -f "$f"
    done
fi

# create custom icons
for e in \
    "inode-directory application-x-smb-share" \
    #
do
    icon_from=`echo "$e"| cut -d\  -f1`
    icon_to=`echo "$e"| cut -d\  -f2`
    find %buildroot/%_iconsdir/ -type f -name ${icon_from}.png | \
    while read p; do
	icon_dir=`dirname $p`
	ln -s ${icon_from}.png $icon_dir/${icon_to}.png ||:
    done
done

%files -n icon-theme-oxygen
%doc COPYING*
%_iconsdir/oxygen*/

%changelog
