# SPDX-License-Identifier: GPL-2.0-only
%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

Name:     kernelshark
Version: 2.4.0
Release: alt1
# Epoch incremented, because previously kernelshark is packaged from trace-cmd
# spec which have much bigger version number (2.9.1).
Epoch:    1
Summary:  KernelShark is a front-end reader of tracing data
License:  GPL-2.0 and LGPL-2.1
Group:    Development/Debug
Url:      https://kernelshark.org/
Vcs:      https://git.kernel.org/pub/scm/utils/trace-cmd/kernel-shark.git

Requires: fonts-ttf-freefont
Requires: trace-cmd

Source:   %name-%version.tar

BuildRequires(pre): rpm-macros-cmake
BuildRequires: cmake
BuildRequires: fontconfig
BuildRequires: fonts-ttf-freefont
BuildRequires: gcc-c++
BuildRequires: libaudit-devel
BuildRequires: libfreeglut-devel
BuildRequires: libgomp-devel
BuildRequires: libjson-c-devel
BuildRequires: libtracecmd-devel
BuildRequires: libtraceevent-devel
BuildRequires: libtracefs-devel
BuildRequires: libXi-devel
BuildRequires: libxml2-devel
BuildRequires: polkit
BuildRequires: qt6-base-devel
BuildRequires: qt6-scxml-devel
BuildRequires: trace-cmd
%{?!_without_check:%{?!_disable_check:
BuildRequires: desktop-file-utils
BuildRequires: libappstream-glib
}}

%define _metainfodir /usr/share/metainfo

%description
KernelShark is a front end reader of trace-cmd(1) output. It reads a
trace-cmd.dat(5) formatted file and produces a graph and list view of
the data.

%prep
%setup

%build
%define optflags_lto %nil
%add_optflags %(getconf LFS_CFLAGS)
%define _cmake__builddir build
%cmake -D_INSTALL_PREFIX=%_prefix -D_LIBDIR=%_libdir
%cmake_build

%install
%cmake_install --component kernelshark
%cmake_install --component polkit-policy
# There is also libkshark-devel component which we don't need.

# error: value "1.1.0" for key "Version" in group "Desktop Entry" is not a known version
sed -i '/Version/d'   %buildroot%_datadir/applications/kernelshark.desktop
install -Dm644 -t %buildroot%_metainfodir .gear/*.appdata.xml

%check
desktop-file-validate %buildroot%_datadir/applications/kernelshark.desktop
appstream-util validate-relax --nonet %buildroot%_metainfodir/*.appdata.xml

%files
%doc README LICENSES/* icons/CC_*
%_bindir/kernelshark
%_bindir/kshark-record
%_bindir/kshark-su-record
%_libdir/libkshark*.so.*
%_libdir/kernelshark/
%_datadir/applications/kernelshark.desktop
%_datadir/icons/kernelshark
%_datadir/polkit-1/actions/org.freedesktop.kshark-record.policy
%_metainfodir/*.appdata.xml

%changelog
