%define _unpackaged_files_terminate_build 1

%define module_name	lkrg
%define module_version	1.0.0
%define module_release	alt1

%define flavour		6.12
%define karch		%ix86 x86_64
BuildRequires(pre): rpm-build-kernel
BuildRequires(pre): kernel-headers-modules-6.12
%setup_kernel_module %flavour

%define module_dir /lib/modules/%kversion-%flavour-%krelease/misc

Summary: Linux Kernel Runtime Guard module
Name: kernel-modules-%module_name-%flavour
Version: %module_version
Release: %module_release.%kcode.%kbuildrelease
License: GPL-2.0-only
Group: System/Kernel and hardware

Packager: Kernel Maintainer Team <kernel@packages.altlinux.org>

ExclusiveOS: Linux
Url: https://lkrg.org/
Vcs: https://github.com/lkrg-org/lkrg

BuildRequires: kernel-headers-modules-%flavour = %kepoch%kversion-%krelease
BuildRequires: kernel-source-%module_name = %module_version
%{?!_without_check:%{?!_disable_check:
BuildRequires: kernel-image-%flavour = %kepoch%kversion-%krelease
BuildRequires: rpm-build-vm
}}

Provides:  kernel-modules-%module_name-%kversion-%flavour-%krelease = %version-%release
Conflicts: kernel-modules-%module_name-%kversion-%flavour-%krelease < %version-%release
Conflicts: kernel-modules-%module_name-%kversion-%flavour-%krelease > %version-%release

Requires: lkrg-common >= %module_version

ExclusiveArch: %karch

%description
Linux Kernel Runtime Guard (LKRG) is a loadable kernel module that performs
runtime integrity checking of the Linux kernel and detection of security
vulnerability exploits against the kernel. As controversial as this concept is,
LKRG attempts to post-detect and hopefully promptly respond to unauthorized
modifications to the running Linux kernel (integrity checking) or to
credentials (such as user IDs) of the running processes (exploit
detection). For process credentials, LKRG attempts to detect the exploit and
take action before the kernel would grant the process access (such as open a
file) based on the unauthorized credentials.

%prep
rm -rf %module_name-%module_version
tar -xf %kernel_src/kernel-source-%module_name-%module_version.tar
%setup -D -T -n %module_name-%module_version

%build
%make_build -C %_usrsrc/linux-%kversion-%flavour modules M=$(pwd)

%install
install -D -p -m0644 lkrg.ko %buildroot%module_dir/lkrg.ko

%check
timeout 60 \
vm-run --kvm=cond --kernel=%flavour --sbin --loglevel=debug "
	insmod lkrg.ko log_level=3
	sleep 2
	echo 1 > /proc/sys/lkrg/trigger
	modprobe -a fuse
	sleep 2
	modprobe -r fuse
	rmmod lkrg
" &> boot.log &&
grep 'LKRG initialized successfully' boot.log &&
grep 'LKRG unloaded' boot.log &&
grep 'Power down' boot.log &&
! grep 'Kernel panic|BUG:|WARNING:|ALERT:|FAULT:|FATAL:|Oops|Call Trace' || {
	cat >&2 boot.log
	exit 1
}
# Maybe interesting to see even on successful build.
grep -i 'LKRG' boot.log

%post
if [ $1 -eq 2 ]; then
	service lkrg condrestart
fi

%files
%doc README
%dir %module_dir
%module_dir/lkrg.ko

%changelog
