%define _unpackaged_files_terminate_build 1

Name: kdiff3
Version: 1.12.3
Release: alt1
Summary: Compare + merge 2 or 3 files or directories
%K6init

License: GPL-2.0-or-later
Group: Text tools
URL: https://invent.kde.org/sdk/kdiff3

# https://invent.kde.org/sdk/kdiff3.git
Source: %name-%version.tar

BuildRequires(pre): rpm-build-kf6
BuildRequires: cmake
BuildRequires: qt6-declarative-devel qt6-5compat-devel
BuildRequires: boost-devel boost-signals-devel
BuildRequires: desktop-file-utils
BuildRequires: gettext
BuildRequires: kf6-kio-devel 
BuildRequires: kf6-kwidgetsaddons-devel
BuildRequires: kf6-kparts-devel
BuildRequires: kf6-kiconthemes-devel
BuildRequires: kf6-kdoctools-devel
BuildRequires: kf6-kcrash-devel
BuildRequires: kf6-kcoreaddons-devel
BuildRequires: kf6-ki18n-devel
BuildRequires: kf6-kbookmarks-devel
BuildRequires: rpm-macros-cmake 
BuildRequires: cmake-modules
BuildRequires: extra-cmake-modules
BuildRequires: kf6-ktextwidgets-devel

%description
KDiff3 is a program that
- compares and merges two or three input files or directories,
- shows the differences line by line and character by character (!),
- provides an automatic merge-facility and
- an integrated editor for comfortable solving of merge-conflicts
- has support for KDE-KIO (ftp, sftp, http, fish, smb)
- and has an intuitive graphical user interface.

%prep
%setup
rm -rf po/*/diff_ext.po

%build
%K6build

%install
%K6install

%find_lang %name --with-kde --all-name

%files -f %name.lang

%doc ChangeLog INSTALL README LICENSES/*
%_K6bin/%name
%_K6plug/kf6/kfileitemaction/*kdiff3*.so
%_datadir/metainfo/org.kde.%name.appdata.xml
%_K6xdgapp/org.kde.%name.desktop
%_K6icon/hicolor/*/apps/*.png
%_K6icon/hicolor/scalable/apps/kdiff3.svgz

%changelog
