%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict,lint=relaxed

Name:     kcptun
Version: 20231012
Release: alt1

Summary:  A Tunnel based on KCP with N:M multiplexing and FEC
License:  MIT
Group:    Networking/Other
Url:      https://github.com/xtaci/kcptun

Source:   %name-%version.tar
Patch3500: alt-github.com-templexxx-cpu-support-LoongArch.patch

BuildRequires: golang
%{?!_without_check:%{?!_disable_check:
BuildRequires: curl
BuildRequires: iproute2
BuildRequires: python3
}}

%description
%summary.

KCP is a reliable (ARQ) transmission protocol (on top of UDP) with the
focus on low-latency in contrast to TCP which focus on bandwidth.

FEC is a forward error correction (using Reed-Solomon codes), achieving
reliability in the network with packet losses.

%prep
%setup
%patch3500 -p1

%build
go build -v -buildmode=pie -ldflags="-X main.VERSION=%version" -o %name-client ./client
go build -v -buildmode=pie -ldflags="-X main.VERSION=%version" -o %name-server ./server
# Please do not upgrade beyond this version.
./kcptun-client --version | grep -Fx 'kcptun version 20231012'

%install
install -Dp %name-client %name-server -t %buildroot%_bindir
install -Dpm0644 .gear/sysctl.conf %buildroot%_sysconfdir/sysctl.d/88-%name.conf.example
install -Dpm0644 .gear/%name.service %buildroot%_unitdir/%name-client.service
install -Dpm0644 .gear/%name.service %buildroot%_unitdir/%name-server.service
install -Dpm0640 .gear/*.json -t %buildroot%_sysconfdir/%name

%check
.gear/kcptun-test.sh

%post
%post_service %name-client
%post_service %name-server

%preun
%preun_service %name-client
%preun_service %name-server

%files
%doc *.md
%_bindir/%name-client
%_bindir/%name-server
%attr(750,root,wheel) %dir %_sysconfdir/%name
%attr(640,root,wheel) %config(noreplace) %_sysconfdir/%name/*
%_sysconfdir/sysctl.d/*
%_unitdir/*.service

%changelog
